package net.herit.ami.features.stat.service.Holiday;

import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(value = "holidaty-data", url = "${open.host}", configuration = FeignClientProperties.FeignClientConfiguration.class)
public interface HolidayFeignClient {

    /**
     * 월별로 구분(공휴일), 요일, 공휴일 여부 등의 정보를 제공한다.
     *
     * @param solYear : 연 ex) 2019
     * @param solMonth : 월 ex) 03
     * @param serviceKey : api 인증키
     * @param dataType : json 타입 (디폴트 XML)
     * @return
     */
    @GetMapping(value = "${open.url-request-holiday-data}")
    Response requestHolidayDataByAll(
            @RequestParam(name = "solYear") String solYear,
            @RequestParam(name = "solMonth") String solMonth,
            @RequestParam("serviceKey") String serviceKey,
            @RequestParam(name = "_type") String dataType
    );
}
