package net.herit.ami.features.stat.service.Holiday;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.service.JobService;
import net.herit.ami.features.stat.job.HoliDayDataJob;
import net.herit.ami.features.stat.property.HolidayDataProperty;
import net.herit.ami.features.stat.property.HolidayDataPropertySecond;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;

@Service
@RequiredArgsConstructor
public class HoliDayDataJobService2 implements JobService {

    private static final String NAME ="HoliDay2DataJobService";

    private static final String GROUP = "STAT";

    private final HolidayDataPropertySecond propertySecond;
    private final Scheduler scheduler;

    private final CallLogger call;
    @Override
    public void initBatch() {

        JobDetail jobDetail = buildJobDetail(HoliDayDataJob.class, NAME, GROUP, new HashMap<>());

        try {
            if(propertySecond.isEnable())
                scheduler.scheduleJob(jobDetail, buildJobTrigger(propertySecond.getSchedule()));
        } catch (SchedulerException e) {
            call.error("FileReaderService :: scheduler error :: {}", LocalDateTime.now());
        }

    }

}

