package net.herit.ami.features.stat.job;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.dto.ApiClasses;
import net.herit.ami.commons.dto.SvcClasses;
import net.herit.ami.commons.job.QuartzJobBeans;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.oms.aop.LogTracer;
import net.herit.ami.commons.logger.oms.field.OmsLogField;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.response.BackendServiceStatus;
import net.herit.ami.commons.util.DateTimeUtil;
import net.herit.ami.features.stat.repository.dataportal.SndRepository;
import net.herit.ami.features.stat.service.ResponseService;
import net.herit.ami.features.stat.service.snd.SndService;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Value;

/**
 *
 */
@RequiredArgsConstructor
public class SndEnterConsumeDataJob extends QuartzJobBeans{

	private final CallLogger call;
	private final OmsLogger oms;

	private final DateTimeUtil dateTimeUtil;
	private final String JOB_NAME = this.getClass().getSimpleName();
	private final SndService sndService;

	@Value("${dataportal.serviceKey}")
	private String serviceKey;

	/**
	 *
	 * @param context
	 */
	@Override
	@LogTracer(apiClass = ApiClasses.SND_ENERGYDATA, svcClass = SvcClasses.REQUEST_SND_CUST)
	protected void initJob(JobExecutionContext context) {
		call.info("{}: {}", JOB_NAME, dateTimeUtil.getNow_yyyyMMddHHmmss());
		int result= 0;
		try {
			result = sndService.makeSndDTO(serviceKey);
		}catch (Exception e){
			call.error(e.getMessage(),e.getCause());
			oms.addOmsData(OmsLogField.API_CLASS, String.valueOf(result));
//			oms.setStatusAndResult(BackendServiceStatus.DB_INSERT_ERROR);
		}
		endOms(result);
	}

	public void endOms(int result){
		if(result < 1){
			oms.addOmsData(OmsLogField.API_CLASS, String.valueOf(result));
			oms.setStatusAndResult(BackendServiceStatus.DB_INSERT_ERROR);
		}else {
			oms.addOmsData(OmsLogField.R1, String.valueOf(result));
			oms.setStatusAndResult(BackendServiceStatus.SUCCESS);
		}
	}

}