package net.herit.ami.features.stat.job;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.dto.ApiClasses;
import net.herit.ami.commons.dto.SvcClasses;
import net.herit.ami.commons.job.QuartzJobBeans;
import net.herit.ami.commons.logger.call.field.CallLogField;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.call.log.CallObject;
import net.herit.ami.commons.logger.context.LoggerContext;
import net.herit.ami.commons.logger.oms.aop.LogTracer;
import net.herit.ami.commons.logger.oms.field.OmsLogField;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.response.BackendServiceStatus;
import net.herit.ami.commons.util.DateTimeUtil;
import net.herit.ami.features.stat.service.smp.SmpService;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Value;

/**
 *
 */
@RequiredArgsConstructor
public class SmpEnterConsumeDataJob extends QuartzJobBeans{

	private final CallLogger call;
	private final OmsLogger oms;
	private final DateTimeUtil dateTimeUtil;
	private final String JOB_NAME = this.getClass().getSimpleName();
	private final SmpService smpService;
	int[] areaCd = {1,9};
	@Value("${dataportal.serviceKey}")
	private String serviceKey;
	/**
	 *
	 * @param context
	 */
	@Override
	@LogTracer(apiClass = ApiClasses.SMP_ENERGYDATA, svcClass = SvcClasses.REQUEST_SMP_CUST)
	protected void initJob(JobExecutionContext context) {
		call.info("{}: {}", JOB_NAME, dateTimeUtil.getNow_yyyyMMddHHmmss());

		CallObject cObj = LoggerContext.getCallLogger();
		String callId = cObj.getCallData(CallLogField.LOG_ID);

		call.info("callId:{}", callId);
		int resultCount = 0;
		for (int i = 0; i < areaCd.length; ++i) resultCount += smpService.GetSmpDataAndInsert(areaCd[i], serviceKey);
		oms.addOmsData(OmsLogField.R1, String.valueOf(resultCount));
		oms.setStatusAndResult(BackendServiceStatus.SUCCESS);

	};

}