package net.herit.ami.features.stat.dto.response_model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
public abstract class HolidayOnlyData {

    @JsonProperty("response")
    private Response response;

    public static class Response {
        @JsonProperty("body")
        private Body body;
        @JsonProperty("header")
        private Header header;
    }
    @Data
    public static class Body {
        @JsonProperty("totalCount")
        private int totalcount;
        @JsonProperty("pageNo")
        private int pageno;
        @JsonProperty("numOfRows")
        private int numofrows;
        @JsonProperty("items")
        private Items items;
    }
    @Data
    public static class Items {
        @JsonProperty("item")
        private Item item;
    }
    @Data
    public static class Item {
        @JsonProperty("seq")
        private int seq;
        @JsonProperty("locdate")
        private int locdate;
        @JsonProperty("isHoliday")
        private String isholiday;
        @JsonProperty("dateName")
        private String datename;
        @JsonProperty("dateKind")
        private String datekind;
    }
    @Data
    public static class Header {
        @JsonProperty("resultMsg")
        private String resultmsg;
        @JsonProperty("resultCode")
        private String resultcode;
    }
}
