package net.herit.ami.commons.util;

import java.nio.ByteBuffer;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class UuidUtil {

	private final DateTimeUtil dateTimeUtil;

	/**
	 *
	 * @return uuid 문자열 중 앞에 10자리
	 */
	public String getUuid() {
		String uuid = UUID.randomUUID().toString();
		uuid = uuid.replaceAll("-", "").substring(0, 9);
		return uuid;
    }

	/**
	 *
	 * @return uuid 문자열에서
	 */
	public String makeShortUUID() {
		return makeShortUUID(32);
	}

	/**
	 *
	 * @param radix 변환할 진수
	 * @return 지정한 radix 로 변환된 문자열
	 */
	public String makeShortUUID(int radix) {
		if(radix > Character.MAX_RADIX) {
			radix = Character.MAX_RADIX;
		}
		UUID uuid = UUID.randomUUID();
		long l = ByteBuffer.wrap(uuid.toString().getBytes()).getLong();
		return Long.toString(l, radix);
	}

	/**
	 *
	 * @return uuid 문자열
	 */
	public String makeUUID() {
		return UUID.randomUUID().toString();
	}

	/**
	 *
	 * @return uuid 문자열에서 하이픈(-)을 제외한 문자열
	 */
	public String makeUUIDWithoutHypen() {
		return makeUUID().replaceAll("-", "");
	}

	/**
	 *
	 * @return 날짜(yyyyMMddHHmmss)와 숫자/영문포함한 10자리 문자열
	 */
	public String makeTxId() {
		return dateTimeUtil.getNow_yyyyMMddHHmmss() +"."+ makeRandomAlphaNumeric(10);
	}

	/**
	 * 알파벳(대소문자)+숫자로 조합된 문자열을 반환합니다.
	 *
	 * @param length : 문자열 길이(최소값 5, 최대값 64)
	 * @return 주어진 length 의 알파벳+숫자 문자열
	 */
	public String makeRandomAlphaNumeric(int length) {
		if(length < 5) {
			length = 5;
		}
		if(length > 64) {
			length = 64;
		}
		return RandomStringUtils.randomAlphanumeric(length);
	}

	/**
	 * 알파벳(대소문자)으로 조합된 문자열을 반환합니다.
	 *
	 * @param length : 문자열 길이(최소값 5, 최대값 64)
	 * @return 주어진 length 의 알파벳 문자열
	 */
	public String makeRandomAlpha(int length) {
		if(length < 5) {
			length = 5;
		}
		if(length > 64) {
			length = 64;
		}
		return RandomStringUtils.randomAlphabetic(length);
	}
}
