package net.herit.ami.commons.logger.oms.log;

import java.util.EnumMap;
import java.util.Map;

import net.herit.ami.commons.dto.ServiceMetaInfo;
import net.herit.ami.commons.logger.LogObject;
import net.herit.ami.commons.logger.call.field.CallLogField;
import net.herit.ami.commons.logger.context.LoggerContext;
import net.herit.ami.commons.logger.oms.field.OmsLogField;
import net.herit.ami.commons.util.DateTimeUtil;
import net.herit.ami.commons.util.UuidUtil;
import org.apache.commons.lang3.RandomStringUtils;

public class OmsObject implements LogObject {
	private static final String DELIM = "|";
	
	Map<OmsLogField, String> omsData;
    DateTimeUtil dateTimeUtil;
    UuidUtil uuidUtil;
    
    public OmsObject() {
    	omsData = new EnumMap<>(OmsLogField.class);
    	dateTimeUtil = new DateTimeUtil();
    	uuidUtil = new UuidUtil(dateTimeUtil);
    	
    	initOmsData();
    	
    	omsData.put(OmsLogField.REQ_TIME, dateTimeUtil.getNow_yyyyMMddHHmmssSSS());
    }
    
    private void initOmsData() {
    	omsData.clear();
        for(OmsLogField field : OmsLogField.values()) {
            omsData.put(field, "");
        }

        omsData.put(OmsLogField.TX_ID,
                dateTimeUtil.getNow_yyyyMMddHHmm() +"-"+ RandomStringUtils.randomAlphanumeric(5));

        omsData.put(OmsLogField.LOG_TYPE, "SVC");
        omsData.put(OmsLogField.SVC_ID, ServiceMetaInfo.SVC_ID.getData());
        omsData.put(OmsLogField.APP_TYPE, ServiceMetaInfo.APP_TYPE.getData());
    }
    
    public String getOmsData(OmsLogField key) {
        return omsData.get(key);
    }
    
    public void setOmsData(OmsLogField key, String data) {
    	omsData.put(key, data);
    }

    protected String getLogString() {
    	omsData.put(OmsLogField.RES_TIME, dateTimeUtil.getNow_yyyyMMddHHmmssSSS());
    	omsData.put(OmsLogField.LOG_TIME, dateTimeUtil.getNow_yyyyMMddHHmmssSSS());
        
        StringBuilder sb = new StringBuilder();
        
        for (OmsLogField txLogField : OmsLogField.values()) {
        	sb.append(omsData.get(txLogField)).append(DELIM);
        }
        
        return sb.toString();
    }

    public OmsObject cloneOms() {
        OmsObject omsClone = new OmsObject();
        omsClone.setOmsData(OmsLogField.TX_ID, LoggerContext.getCallLogger().getCallData(CallLogField.LOG_ID));
        omsClone.setOmsData(OmsLogField.REQ_TIME, dateTimeUtil.getNow_yyyyMMddHHmmssSSS());
        omsClone.setOmsData(OmsLogField.API_CLASS, this.omsData.get(OmsLogField.API_CLASS));
        omsClone.setOmsData(OmsLogField.SVC_CLASS, this.omsData.get(OmsLogField.SVC_CLASS));
        omsClone.setOmsData(OmsLogField.R1, this.omsData.get(OmsLogField.R1));
        return omsClone;
    }
}
