package net.herit.ami.commons.config;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.service.JobService;
import net.herit.ami.features.stat.service.Holiday.HoliDayDataJobService;
import net.herit.ami.features.stat.service.Holiday.HoliDayDataJobService2;
import net.herit.ami.features.stat.service.smp.SmpConsumeDataJobService;
import net.herit.ami.features.stat.service.snd.SndConsumeDataJobService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RequiredArgsConstructor
public class QuartzStarter {
	private final SndConsumeDataJobService sndConsumeDataJobService;
	private final SmpConsumeDataJobService smpConsumeDataJobService;
	private final HoliDayDataJobService holiDayDataJobService;
	private final HoliDayDataJobService2 holiDayDataJobService2;

	@Bean
	public void startSmp(){
		smpConsumeDataJobService.initBatch();
	}
	@Bean
	public void startSnd(){
		sndConsumeDataJobService.initBatch();
	}
	@Bean
	public void startHoliDayBatch(){
		holiDayDataJobService.initBatch();
	}
	@Bean
	public void startHoliDay2Batch(){
		holiDayDataJobService2.initBatch();
	}
}
