package net.herit.ami.features.stat.service.snd;

import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(value = "snd-enter", url = "${dataportal.host}")
public interface SndEnterFeignClient {

    /**
     * 서비스에 동의한 회원 전체의 date 전기소비량을 조회합니다.
     *
     * @param serviceKey : api 인증키
     * @return
     */
    @GetMapping(value = "${dataportal.snd.uri-request-consume-data}")
    Response requestConsumeData(
            @RequestParam("serviceKey") String serviceKey
    );
}
