package net.herit.ami.features.stat.service.smp;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.exception.CommonException;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.response.BackendServiceStatus;
import net.herit.ami.features.stat.dto.SmpXmlDTO.SmpDTO;
import net.herit.ami.features.stat.dto.SmpXmlDTO.SmpRoot;
import net.herit.ami.features.stat.repository.dataportal.SmpRepository;
import net.herit.ami.features.stat.service.ResponseService;
import org.springframework.stereotype.Service;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.util.ArrayList;

@Service
@RequiredArgsConstructor
public class SmpService {
    private final CallLogger call;
    private final OmsLogger oms;
    private final SmpRepository smpRepository;
    private final ResponseService responseService;
    private final SmpEnterFeignClient smpEnterFeignClient;

    // 메소드명의 접두사가 여러개이고(to,Do,Get), Get과 Insert 두가지의 동작을 명시하고있어서 역할을 명확히 알기가 힘듭니다
    public int toDoGetSmpDataAndInsert(int i, String serviceKey) {
        ; // ???
        ArrayList<SmpDTO> smpList = getRresponseItme(i, serviceKey);

        return sendSmp(smpList, i);
    }
    //관심사 분리 실패 ....
    // 메소드명 오타 있음
    private ArrayList<SmpDTO> getRresponseItme(int area, String serviceKeys) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(SmpRoot.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            // 언마샬링 하는 부분과 response 받아오는 부분을 분리해보는건 어떨까요?
            SmpRoot smpResponse = (SmpRoot) unmarshaller.unmarshal( new StringReader(
                    responseService.responseXmlToString(smpEnterFeignClient.requestConsumeDataByAll(area, serviceKeys))));

            // 메시지 체인에 해당되는 부분인것 같습니다.
            // 해결방법으로 Hide Delegate를 참고하면 좋을것 같습니다.
            return smpResponse.getBody().getItems().getItem();
        } catch (JAXBException e) {
            call.error("ResponseService class in method explorerSnd JAXBException : {}", e.getMessage());
            throw new CommonException(e.getMessage());
        }
    }

    private int sendSmp(ArrayList<SmpDTO> smpList, int areaCd) {
        int insertCount = 0;

        // forEach 문으로 바꾸면 좀더 보기 좋을것같습니다
        for (int i = 0; i < smpList.size(); ++i){
            insertCount += insertCall(buildSmpDto( smpList.get(i)));
        }
        call.debug("smpList insert SUCCESS point : {}, areaCd : {}", insertCount, areaCd);
        return insertCount;
    }

    private SmpDTO buildSmpDto(SmpDTO smpDTO) {
        // 잘못된 빌더패턴 사용법인것같습니다.
        return new SmpDTO().builder()
                .idx(smpDTO.getIdx())
                .areaCd(smpDTO.getAreaCd())
                .smp(smpDTO.getSmp())
                .tradeHour(String.format("%02d", Integer.parseInt(smpDTO.getTradeHour())))
                .tradeDay(smpDTO.getTradeDay())
                .created_at(smpDTO.getCreated_at())
                .build();
    }

    private int insertCall(SmpDTO params){
        int success = 0;
        try {
            success = smpRepository.insertSmp(params);
        }catch (Exception e){
            oms.setStatusAndResult(BackendServiceStatus.DB_INSERT_ERROR);
        }
        return success;
    }


}
