package net.herit.ami.features.stat.service;

import feign.Response;
import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.exception.CommonException;
import net.herit.ami.commons.exception.ExceptionType;
import net.herit.ami.commons.logger.call.log.CallLogger;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;

@Service
@RequiredArgsConstructor
public class ResponseService {
    private final CallLogger call;
    private final String JOB_NAME = this.getClass().getSimpleName();
    private final DefaultConnectService defaultconnectService;
    // 접근제어자가 없음
    String line = null;
    public String responseXmlToString(Response response) {
        StringBuilder builder = new StringBuilder();
        logStamp(response);
        try {
            BufferedReader reader = new BufferedReader(response.body().asReader(Charset.defaultCharset()));
            while ((line = reader.readLine()) != null){
                builder.append(line);
            }
            call.info("conectApi result {} : {}","explorerSnd", builder.toString());

            return builder.toString();

        } catch (IOException ex){
            call.error("Exceprion point {} , massge ",JOB_NAME, ex.getMessage());
            // CommonExeption을 던져도 받아서 처리해주는 부분은 없는것같아요
            throw new CommonException(ExceptionType.RESPONE_CAUSE_EXCEPTION);
        }
    }
    public void logStamp(Response response){
        final String printRequest = response.request().toString();
        final String printResponse = response.toBuilder()
                .headers(response.headers())
                .body(response.body())
                .build()
                .toString();

        call.info("\nConnection:\n\n{}", defaultconnectService.getConnectionLog(printRequest, printResponse));
    }

}