package net.herit.ami.features.stat.job;

import feign.Response;
import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.dto.ApiClasses;
import net.herit.ami.commons.dto.SvcClasses;
import net.herit.ami.commons.job.QuartzJobBeans;
import net.herit.ami.commons.logger.call.field.CallLogField;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.call.log.CallObject;
import net.herit.ami.commons.logger.context.LoggerContext;
import net.herit.ami.commons.logger.oms.aop.LogTracer;
import net.herit.ami.commons.logger.oms.field.OmsLogField;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.response.BackendServiceStatus;
import net.herit.ami.commons.util.DateTimeUtil;
import net.herit.ami.features.stat.dto.Holiday.HolidayDataDAO;
import net.herit.ami.features.stat.dto.response_model.*;
import net.herit.ami.features.stat.repository.dataportal.HolidayRepository;
import net.herit.ami.features.stat.service.ConnectionService;
import net.herit.ami.features.stat.service.Holiday.HolidayFeignClient;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Value;
/**
 *
 */
@RequiredArgsConstructor
public class HoliDayDataJob extends QuartzJobBeans{

	private final CallLogger call;
	private final OmsLogger oms;
	private final DateTimeUtil dateTimeUtil;
	private final String JOB_NAME = this.getClass().getSimpleName();
	private final HolidayRepository holidayRepository;
	private final HolidayFeignClient holidayFeignClient;
	private final ConnectionService connectionService;

	@Value("${dataportal.serviceKey}")
	private String serviceKey;
	/**
	 *
	 * @param context
	 */
	@Override
	@LogTracer(apiClass = ApiClasses.HOLIDAY_ENERGYDATA, svcClass = SvcClasses.REQUEST_HOLIDAY_CUST)
	protected void initJob(JobExecutionContext context) {
		call.info("{}: {}", JOB_NAME, dateTimeUtil.getNow_yyyyMMddHHmmss());
		call.debug("{} init log "+ JOB_NAME, dateTimeUtil.getNow_yyyyMMddHHmmss());

		CallObject cObj = LoggerContext.getCallLogger();
		String callId = cObj.getCallData(CallLogField.LOG_ID);

		String date = dateTimeUtil.getNow_yyyyMM(+1);
		String year = date.substring(0,4);
		String month = date.substring(4,6);

		connectionService.connect(holidayFeignClient.requestHolidayDataByAll(year, month, serviceKey,"json"));

		call.info("callId:{}", callId);
		oms.setStatusAndResult(BackendServiceStatus.SUCCESS);


	}

}