package net.herit.ami.commons.util;

import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;

@Slf4j
public class UuidUtilTests {

    @Test
    public void test() {
        UuidUtil uuidUtil = new UuidUtil(new DateTimeUtil());

        log.info("makeUUID:{}", uuidUtil.makeUUID());
        log.info("makeUUIDWithoutHypen:{}", uuidUtil.makeUUIDWithoutHypen());
        log.info("makeTxId:{}", uuidUtil.makeTxId());
        for(int i=0; i<10; i++) {
            log.info("makeTxId:{}", uuidUtil.makeShortUUID());
        }
    }

    @Test
    public void testIdGenerator() {
        UuidUtil uuidUtil = new UuidUtil(new DateTimeUtil());

        final int length = 10;
        for(int i=0; i<10; i++) {
            log.info("alphaNumeric: {}", uuidUtil.makeRandomAlphaNumeric(length));
            log.info("alpha: {}", uuidUtil.makeRandomAlpha(length));
        }
    }
}
