package net.herit.ami.features.stat.service.smp;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.exception.CommonException;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.response.BackendServiceStatus;
import net.herit.ami.features.stat.dto.SmpXmlDTO.SmpDTO;
import net.herit.ami.features.stat.dto.SmpXmlDTO.SmpRoot;
import net.herit.ami.features.stat.repository.dataportal.SmpRepository;
import net.herit.ami.features.stat.service.ResponseService;
import org.springframework.stereotype.Service;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.util.ArrayList;

@Service
@RequiredArgsConstructor
public class SmpService {
    private final CallLogger call;
    private final OmsLogger oms;
    private final SmpRepository smpRepository;
    private final ResponseService responseService;
    private final SmpEnterFeignClient smpEnterFeignClient;

    public int GetSmpDataAndInsert(int i, String serviceKey) {
        ArrayList<SmpDTO> smpList = getResponseItme(i, serviceKey);

        return sendSmp(smpList, i);
    }
    private ArrayList<SmpDTO> getResponseItme(int area, String serviceKeys) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(SmpRoot.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            String ResponseXml= responseService.responseXmlToString(smpEnterFeignClient.requestConsumeDataByAll(area, serviceKeys));
            SmpRoot smpResponse = (SmpRoot) unmarshaller.unmarshal( new StringReader(ResponseXml));
            return smpResponse.getItem();
        } catch (JAXBException e) {
            call.error("ResponseService class in method explorerSnd JAXBException : {}", e.getMessage());
            throw new CommonException(e.getMessage());
        }
    }

    private int sendSmp(ArrayList<SmpDTO> smpList, int areaCd) {
        int insertCount = 0;

        for(SmpDTO value : smpList){
            insertCount += insertCall(buildSmpDto(value));
        }
        call.debug("smpList insert SUCCESS point : {}, areaCd : {}", insertCount, areaCd);
        return insertCount;
    }

    private SmpDTO buildSmpDto(SmpDTO smpDTO) {
        // 잘못된 빌더패턴 사용법인것같습니다.
        return SmpDTO.builder().idx(smpDTO.getIdx())
                .areaCd(smpDTO.getAreaCd())
                .smp(smpDTO.getSmp())
                .tradeHour(String.format("%02d", Integer.parseInt(smpDTO.getTradeHour())))
                .tradeDay(smpDTO.getTradeDay())
                .created_at(smpDTO.getCreated_at()).
                build();
    }

    private int insertCall(SmpDTO params){
        int success = 0;
        try {
            success = smpRepository.insertSmp(params);
        }catch (Exception e){
            oms.setStatusAndResult(BackendServiceStatus.DB_INSERT_ERROR);
        }
        return success;
    }


}
