package net.herit.ami.commons.response;

public enum BackendServiceStatus {
    SUCCESS(200, 0, ""),
    NOT_PROVIDE_SERVICE(404, 1, "not support : "),
    INVALID_PARAM(400, 2, "invalid parameter"),
    DUPLICATED_CONTENTS(400, 3, "duplicated contents"),
    RESPONSE_CANNOT_BE_NULL(404,401,"Response Connot Be null"),
    SYSTEM_ERROR(500, 4, "Exception"),
    RESPONSE_READ_SYSTEM_ERROR(500, 501, "IOException"),
    MAPPER_ERROR(500, 502, "Mapper pasing error"),
    JSON_PROCESS_ONE(500, 503 ,"One Day Process JSON process Excetion"),
    INSERT_ERROR(500, 504 ,"INSERT ERROR Parameters"),


    ;

    private int statusCode;
    private int detailCode;
    String reason;

    BackendServiceStatus(int statusCode, int detailCode, String reason) {
        this.statusCode = statusCode;
        this.detailCode = detailCode;
        this.reason = reason;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public int getDetailCode() {
        return detailCode;
    }

    public String getReason() {
        return reason;
    }
}
