package net.herit.ami.features.stat.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.exception.CommonException;
import net.herit.ami.commons.exception.ExceptionType;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.logger.oms.field.OmsLogField;
import net.herit.ami.commons.logger.oms.log.OmsLogger;
import net.herit.ami.commons.util.JsonUtil;
import net.herit.ami.features.stat.dto.Holiday.HolidayDataDAO;
import net.herit.ami.features.stat.dto.response_model.HolidaRootResponse;
import net.herit.ami.features.stat.dto.response_model.HolidayDataItem;
import net.herit.ami.features.stat.dto.response_model.SoloHolidayDataItem;
import net.herit.ami.features.stat.repository.dataportal.HolidayRepository;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@RequiredArgsConstructor
public class DefaultConnectService implements ConnectionService{
    private final CallLogger call;
    private final HolidayRepository holidayRepository;
    private final OmsLogger oms;
    private final ObjectMapper mapper = new ObjectMapper();
    @Override
    public void connect(Response connect)throws CommonException {
        call.debug("\n---- Start to Connection And Convert----");
        isnull(connect);
        apiConnectLog(connect);
        commonProcess(connect);
    }
    public void commonProcess(Response connect) throws CommonException{
        try {
            Map<String, String> map = segregate(builderResponseBody(connect));
            int totalCount = Integer.parseInt(map.get("item"));

            if(totalCount > 1){
                HolidaRootResponse resBody = mapper.readValue(map.get("anotherDaybody"), HolidaRootResponse.class);
                anotherDayProcess(resBody.getResponse().getResBody().getItems().getItem(), resBody.getResponse().getResBody().getTotalCount());
            }else if(totalCount == 1){
                onlyDayProcess(map.get("oneDayBody"));
            }else {
                oms.addOmsData(OmsLogField.R1, "0");
                oms.addOmsData(OmsLogField.R2, "0");
            }
        }catch (Exception ex){
            call.error("Error Occurred with External Server request. cause: ", ex);
            throw new CommonException(ExceptionType.EXTERNAL_API_CALL_ERROR);
        }
    }
    private void apiConnectLog(Response connect) {
        final String printRequest = connect.request().toString();
        final String printResponse = connect.toBuilder()
                .headers(connect.headers())
                .body(connect.body())
                .build()
                .toString();
        call.info("\nConnection:\n\n{}", getConnectionLog(printRequest, printResponse));
    }
    private String builderResponseBody(Response connect) {
        try {
            BufferedReader reader = new BufferedReader(connect.body().asReader(Charset.defaultCharset()));
            StringBuilder builder = new StringBuilder();

            String line;
            while ((line = reader.readLine()) != null){
                builder.append(line);
            }
            return builder.toString();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    /*
    * oneDayBody : 하나일때 사용
    * anotherDaybody : 공유일이 많을때 사용하기 위함
    * itmeMap : 공유일이 없는 경우를 확인하기 위함
    * */
    private Map<String, String> segregate(String oneDayBody) {
        Map<String, String> buildMap = new HashMap<>();
        try {

            Map<String,Map<String,Object>> anotherDaybody = mapper.readValue(oneDayBody, new TypeReference<Map<String,Map<String,Object>>>() {});
            Map<String, Object> itmeMap = mapper.readValue(mapper.writeValueAsString(anotherDaybody.get("response").get("body")), new TypeReference<Map<String,Object>>(){});

            buildMap.put("oneDayBody", oneDayBody);
            buildMap.put("anotherDaybody", anotherDaybody.toString());
            buildMap.put("item", itmeMap.get("totalCount").toString());

            return buildMap;
        } catch (IOException e) {
            throw new CommonException(e.getMessage());
        }
    }
    private void isnull(Response connect) {
        if(JsonUtil.isNull(connect)){
            call.info("Failed Connect to External Server.");
            throw new CommonException(ExceptionType.RESPONSE_CANNOT_BE_NULL);
        }
        if(connect.body() == null){
            call.info("response of Conntion. {} , {}"+ connect, connect.body());
            throw new CommonException(ExceptionType.RESPONSE_CANNOT_BE_NULL);
        }
    }
    private void anotherDayProcess(List<HolidayDataItem> resBody, String count) {
        int successCount = 0;

        for (HolidayDataItem a : resBody){
            int success = 0;

            HolidayDataDAO holidayanotherDataDAO = builAnotherHoliDayData(a);
            success += holidayRepository.insertHoliDayData(holidayanotherDataDAO);

            if(success >= 1){
                successCount += success;
            }else {
                call.debug("INSERT ERROR Parameters : " + holidayanotherDataDAO);
            }
        }
        oms.addOmsData(OmsLogField.R2, String.valueOf(successCount));
        oms.addOmsData(OmsLogField.R1, String.valueOf(count));
    }
    private HolidayDataDAO builAnotherHoliDayData(HolidayDataItem a) {
        return new HolidayDataDAO(
                makeLocaldate(a.getLocdate()),
                a.getDateName(),
                a.getDateKind()
        );
    }
    private void onlyDayProcess(String objectBody) {
        int success = 0;
        try {
            HolidayDataDAO holidayDataDAO = buildHolidayDataDAO(mapper.readValue(objectBody, SoloHolidayDataItem.class));
            success = holidayRepository.insertHoliDayData(holidayDataDAO);
        } catch (JsonProcessingException e) {
            throw new CommonException(ExceptionType.JSON_PROCESS_ONE);
        }
        finally {
            oms.addOmsData(OmsLogField.R1, "1");
            oms.addOmsData(OmsLogField.R2, String.valueOf(success));
        }
    }
    private HolidayDataDAO buildHolidayDataDAO(SoloHolidayDataItem readValue) {
        return new HolidayDataDAO(
                makeLocaldate(readValue.getItems().getItem().getLocdate()),
                readValue.getItems().getItem().getDateName(),
                readValue.getItems().getItem().getDateKind()
        );
    }
    private String makeLocaldate(String responseDate) {
        return responseDate.substring(0,4)+"-"+responseDate.substring(4, 6)+"-"+responseDate.substring(6, 8);
    }
    public String getConnectionLog (final String request,final String response) {
        StringBuilder builder = new StringBuilder();
        String NEW = "\n";
        builder
                .append("===== External API Service Connection log =====").append(NEW)
                .append(NEW)

                .append("Request:").append(NEW)
                .append(NEW)
                .append(request).append(NEW)
                .append(NEW)
                .append("===============================================").append(NEW)
                .append(NEW)

                .append("Response:").append(NEW)
                .append(NEW)
                .append(response).append(NEW)
                .append(NEW)
                .append("===============================================").append(NEW)
                .append(NEW);
        return builder.toString();
    }
}
