package net.herit.ami.commons.response;

public enum BackendServiceStatus {
    SUCCESS(200, 0, ""),
    INTERNAL_SERVER_ERROR(500, 0, "internal server error"),

    DB_INSERT_ERROR(500, 3, "db insert error"),
    SMP_SERVER_RECV_NULL(502, 850, "SMP List Null"),

    SND_SERVER_RECV_NULL(502, 850, "SMP List Null"),

    ;

    private int statusCode;
    private int detailCode;
    String reason;

    BackendServiceStatus(int statusCode, int detailCode, String reason) {
        this.statusCode = statusCode;
        this.detailCode = detailCode;
        this.reason = reason;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public int getDetailCode() {
        return detailCode;
    }

    public String getReason() {
        return reason;
    }
}
