"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const makePathResolver_1 = __importDefault(require("./makePathResolver"));
const recursiveResolveIEV_1 = __importDefault(require("./recursiveResolveIEV"));
const resolvePathFrom = __importStar(require("./resolvePathFrom"));
vi.mock('../resolveImmediatelyExported');
vi.mock('./resolvePathFrom');
describe('recursiveResolveIEV', () => {
    let set;
    let mockResolver;
    const spies = {
        pathResolver: (0, makePathResolver_1.default)('my', {}, [])
    };
    beforeEach(() => {
        set = { test: { filePath: ['my/path'], exportName: 'exportIt' } };
        mockResolver = vi.spyOn(spies, 'pathResolver');
        vi.spyOn(resolvePathFrom, 'default').mockImplementation(() => 'absolute/my/path');
    });
    it('should call the resolver', () => __awaiter(void 0, void 0, void 0, function* () {
        yield (0, recursiveResolveIEV_1.default)(spies.pathResolver, set, () => true);
        expect(mockResolver).toHaveBeenCalledWith('my/path');
    }));
    it('should not resolve anything if multiple path in filePath', () => __awaiter(void 0, void 0, void 0, function* () {
        set.test.filePath.push('baz');
        yield (0, recursiveResolveIEV_1.default)(spies.pathResolver, set, () => true);
        expect(mockResolver).not.toHaveBeenCalledWith();
    }));
});
