import type { Component, AsyncComponent } from 'vue';
import type { Args, ComponentAnnotations, StoryAnnotations, AnnotatedStoryFn } from '@storybook/csf';
import type { StoryFnVueReturnType } from './types';
export type { Args, ArgTypes, Parameters, StoryContext } from '@storybook/csf';
export declare type VueFramework = {
    component: Component<any, any, any, any> | AsyncComponent<any, any, any, any>;
    storyResult: StoryFnVueReturnType;
};
/**
 * Metadata to configure the stories for a component.
 *
 * @see [Default export](https://storybook.js.org/docs/formats/component-story-format/#default-export)
 */
export declare type Meta<TArgs = Args> = ComponentAnnotations<VueFramework, TArgs>;
/**
 * Story function that represents a CSFv2 component example.
 *
 * @see [Named Story exports](https://storybook.js.org/docs/formats/component-story-format/#named-story-exports)
 */
export declare type StoryFn<TArgs = Args> = AnnotatedStoryFn<VueFramework, TArgs>;
/**
 * Story function that represents a CSFv3 component example.
 *
 * @see [Named Story exports](https://storybook.js.org/docs/formats/component-story-format/#named-story-exports)
 */
export declare type StoryObj<TArgs = Args> = StoryAnnotations<VueFramework, TArgs>;
/**
 * Story function that represents a CSFv2 component example.
 *
 * @see [Named Story exports](https://storybook.js.org/docs/formats/component-story-format/#named-story-exports)
 *
 * NOTE that in Storybook 7.0, this type will be renamed to `StoryFn` and replaced by the current `StoryObj` type.
 *
 */
export declare type Story<TArgs = Args> = StoryFn<TArgs>;
