import "core-js/modules/es.array.reduce.js";
import Vue from 'vue';
import { sanitizeStoryContextUpdate } from '@storybook/store';
import { extractProps } from './util';
import { VALUES } from './render';
export const WRAPS = 'STORYBOOK_WRAPS';

function prepare(rawStory, innerStory) {
  let story;

  if (typeof rawStory === 'string') {
    story = {
      template: rawStory
    };
  } else if (rawStory != null) {
    story = rawStory;
  } else {
    return null;
  } // @ts-ignore
  // eslint-disable-next-line no-underscore-dangle


  if (!story._isVue) {
    if (innerStory) {
      story.components = Object.assign({}, story.components || {}, {
        story: innerStory
      });
    }

    story = Vue.extend(story); // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307984824
  } else if (story.options[WRAPS]) {
    return story;
  }

  return Vue.extend({
    // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307985279
    [WRAPS]: story,
    // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307984824
    [VALUES]: Object.assign({}, innerStory ? innerStory.options[VALUES] : {}, extractProps(story)),
    functional: true,

    render(h, {
      data,
      parent,
      children
    }) {
      return h(story, Object.assign({}, data, {
        // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307986196
        props: Object.assign({}, data.props || {}, parent.$root[VALUES])
      }), children);
    }

  });
}

export function decorateStory(storyFn, decorators) {
  return decorators.reduce((decorated, decorator) => context => {
    let story;
    const decoratedStory = decorator(update => {
      story = decorated(Object.assign({}, context, sanitizeStoryContextUpdate(update)));
      return story;
    }, context);

    if (!story) {
      story = decorated(context);
    }

    if (decoratedStory === story) {
      return story;
    }

    return prepare(decoratedStory, story);
  }, context => prepare(storyFn(context)));
}