import "core-js/modules/es.array.slice.js";
import "core-js/modules/es.object.freeze.js";

var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

import "core-js/modules/es.function.name.js";
import "core-js/modules/es.object.keys.js";
import "core-js/modules/es.array.concat.js";
import "core-js/modules/es.object.assign.js";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-underscore-dangle */
import dedent from 'ts-dedent';
import Vue from 'vue';
export var COMPONENT = 'STORYBOOK_COMPONENT';
export var VALUES = 'STORYBOOK_VALUES';
var root = new Vue({
  data: function data() {
    var _ref;

    return _ref = {}, _defineProperty(_ref, COMPONENT, undefined), _defineProperty(_ref, VALUES, {}), _ref;
  },
  render: function render(h) {
    var children = this[COMPONENT] ? [h(this[COMPONENT])] : undefined;
    return h('div', {
      attrs: {
        id: 'root'
      }
    }, children);
  }
});
export var render = function render(props, context) {
  var _component$__docgenIn;

  var id = context.id,
      Component = context.component,
      argTypes = context.argTypes;
  var component = Component;

  if (!component) {
    throw new Error("Unable to render story ".concat(id, " as the component annotation is missing from the default export"));
  }

  var componentName = 'component'; // if there is a name property, we either use it or preprend with sb- in case it's an invalid name

  if (component.name) {
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore isReservedTag is an internal function from Vue, might be changed in future releases
    var isReservedTag = Vue.config.isReservedTag && Vue.config.isReservedTag(component.name);
    componentName = isReservedTag ? "sb-".concat(component.name) : component.name;
  } else if ((_component$__docgenIn = component.__docgenInfo) !== null && _component$__docgenIn !== void 0 && _component$__docgenIn.displayName) {
    var _component$__docgenIn2;

    // otherwise, we use the displayName from docgen, if present
    componentName = (_component$__docgenIn2 = component.__docgenInfo) === null || _component$__docgenIn2 === void 0 ? void 0 : _component$__docgenIn2.displayName;
  }

  return {
    props: Object.keys(argTypes),
    components: _defineProperty({}, componentName, component),
    template: "<".concat(componentName, " v-bind=\"$props\" />")
  };
};
export function renderToDOM(_ref2, domElement) {
  var title = _ref2.title,
      name = _ref2.name,
      storyFn = _ref2.storyFn,
      args = _ref2.storyContext.args,
      showMain = _ref2.showMain,
      showError = _ref2.showError,
      showException = _ref2.showException,
      forceRemount = _ref2.forceRemount;
  Vue.config.errorHandler = showException; // FIXME: move this into root[COMPONENT] = element
  // once we get rid of knobs so we don't have to re-create
  // a new component each time

  var element = storyFn();

  if (!element) {
    showError({
      title: "Expecting a Vue component from the story: \"".concat(name, "\" of \"").concat(title, "\"."),
      description: dedent(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n        Did you forget to return the Vue component from the story?\n        Use \"() => ({ template: '<my-comp></my-comp>' })\" or \"() => ({ components: MyComp, template: '<my-comp></my-comp>' })\" when defining the story.\n      "])))
    });
    return;
  }

  showMain(); // at component creation || refresh by HMR or switching stories

  if (!root[COMPONENT] || forceRemount) {
    root[COMPONENT] = element;
  } // @ts-ignore https://github.com/storybookjs/storrybook/pull/7578#discussion_r307986139


  root[VALUES] = Object.assign({}, element.options[VALUES], args);

  if (!root.$el) {
    root.$mount(domElement);
  }
}