function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import "core-js/modules/es.object.assign.js";
import "core-js/modules/es.object.to-string.js";
import Vue from 'vue';
import { sanitizeStoryContextUpdate } from '@storybook/store';
import { extractProps } from './util';
import { VALUES } from './render';
export var WRAPS = 'STORYBOOK_WRAPS';

function prepare(rawStory, innerStory) {
  var _Vue$extend;

  var story;

  if (typeof rawStory === 'string') {
    story = {
      template: rawStory
    };
  } else if (rawStory != null) {
    story = rawStory;
  } else {
    return null;
  } // @ts-ignore
  // eslint-disable-next-line no-underscore-dangle


  if (!story._isVue) {
    if (innerStory) {
      story.components = Object.assign({}, story.components || {}, {
        story: innerStory
      });
    }

    story = Vue.extend(story); // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307984824
  } else if (story.options[WRAPS]) {
    return story;
  }

  return Vue.extend((_Vue$extend = {}, _defineProperty(_Vue$extend, WRAPS, story), _defineProperty(_Vue$extend, VALUES, Object.assign({}, innerStory ? innerStory.options[VALUES] : {}, extractProps(story))), _defineProperty(_Vue$extend, "functional", true), _defineProperty(_Vue$extend, "render", function render(h, _ref) {
    var data = _ref.data,
        parent = _ref.parent,
        children = _ref.children;
    return h(story, Object.assign({}, data, {
      // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307986196
      props: Object.assign({}, data.props || {}, parent.$root[VALUES])
    }), children);
  }), _Vue$extend));
}

export function decorateStory(storyFn, decorators) {
  return decorators.reduce(function (decorated, decorator) {
    return function (context) {
      var story;
      var decoratedStory = decorator(function (update) {
        story = decorated(Object.assign({}, context, sanitizeStoryContextUpdate(update)));
        return story;
      }, context);

      if (!story) {
        story = decorated(context);
      }

      if (decoratedStory === story) {
        return story;
      }

      return prepare(decoratedStory, story);
    };
  }, function (context) {
    return prepare(storyFn(context));
  });
}