"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewAnnotations = void 0;
exports.webpackFinal = webpackFinal;

var _coreCommon = require("@storybook/core-common");

var _docsTools = require("@storybook/docs-tools");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function webpackFinal(webpackConfig = {}, options) {
  var _options$presetsList;

  if (!(0, _docsTools.hasDocsOrControls)(options)) return webpackConfig;
  var vueDocgenOptions = {};
  (_options$presetsList = options.presetsList) === null || _options$presetsList === void 0 ? void 0 : _options$presetsList.forEach(function (preset) {
    if (preset.name.includes('addon-docs') && preset.options.vueDocgenOptions) {
      var appendableOptions = preset.options.vueDocgenOptions;
      vueDocgenOptions = _objectSpread(_objectSpread({}, vueDocgenOptions), appendableOptions);
    }
  });
  webpackConfig.module.rules.push({
    test: /\.vue$/,
    loader: require.resolve('vue-docgen-loader', {
      paths: [require.resolve('@storybook/vue')]
    }),
    enforce: 'post',
    options: {
      docgenOptions: _objectSpread({
        alias: webpackConfig.resolve.alias
      }, vueDocgenOptions)
    }
  });
  return webpackConfig;
}

var previewAnnotations = function (entry = [], options) {
  if (!(0, _docsTools.hasDocsOrControls)(options)) return entry;
  return [...entry, (0, _coreCommon.findDistEsm)(__dirname, 'client/docs/config')];
};

exports.previewAnnotations = previewAnnotations;