"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storiesOf = exports.setAddon = exports.raw = exports.getStorybook = exports.forceReRender = exports.configure = exports.clearDecorators = exports.addParameters = exports.addDecorator = void 0;

require("core-js/modules/es.array.concat.js");

var _core = require("@storybook/core");

require("./globals");

var _render = require("./render");

var _decorateStory = require("./decorateStory");

/* eslint-disable prefer-destructuring */
var framework = 'vue';
var api = (0, _core.start)(_render.renderToDOM, {
  decorateStory: _decorateStory.decorateStory,
  render: _render.render
});

var storiesOf = function storiesOf(kind, m) {
  return api.clientApi.storiesOf(kind, m).addParameters({
    framework: framework
  });
};

exports.storiesOf = storiesOf;

var configure = function configure() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return api.configure.apply(api, [framework].concat(args));
};

exports.configure = configure;
var addDecorator = api.clientApi.addDecorator;
exports.addDecorator = addDecorator;
var addParameters = api.clientApi.addParameters;
exports.addParameters = addParameters;
var clearDecorators = api.clientApi.clearDecorators;
exports.clearDecorators = clearDecorators;
var setAddon = api.clientApi.setAddon;
exports.setAddon = setAddon;
var forceReRender = api.forceReRender;
exports.forceReRender = forceReRender;
var getStorybook = api.clientApi.getStorybook;
exports.getStorybook = getStorybook;
var raw = api.clientApi.raw;
exports.raw = raw;