"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRAPS = void 0;
exports.decorateStory = decorateStory;

require("core-js/modules/es.object.assign.js");

require("core-js/modules/es.object.to-string.js");

var _vue = _interopRequireDefault(require("vue"));

var _store = require("@storybook/store");

var _util = require("./util");

var _render = require("./render");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var WRAPS = 'STORYBOOK_WRAPS';
exports.WRAPS = WRAPS;

function prepare(rawStory, innerStory) {
  var _Vue$extend;

  var story;

  if (typeof rawStory === 'string') {
    story = {
      template: rawStory
    };
  } else if (rawStory != null) {
    story = rawStory;
  } else {
    return null;
  } // @ts-ignore
  // eslint-disable-next-line no-underscore-dangle


  if (!story._isVue) {
    if (innerStory) {
      story.components = Object.assign({}, story.components || {}, {
        story: innerStory
      });
    }

    story = _vue.default.extend(story); // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307984824
  } else if (story.options[WRAPS]) {
    return story;
  }

  return _vue.default.extend((_Vue$extend = {}, _defineProperty(_Vue$extend, WRAPS, story), _defineProperty(_Vue$extend, _render.VALUES, Object.assign({}, innerStory ? innerStory.options[_render.VALUES] : {}, (0, _util.extractProps)(story))), _defineProperty(_Vue$extend, "functional", true), _defineProperty(_Vue$extend, "render", function render(h, _ref) {
    var data = _ref.data,
        parent = _ref.parent,
        children = _ref.children;
    return h(story, Object.assign({}, data, {
      // @ts-ignore // https://github.com/storybookjs/storybook/pull/7578#discussion_r307986196
      props: Object.assign({}, data.props || {}, parent.$root[_render.VALUES])
    }), children);
  }), _Vue$extend));
}

function decorateStory(storyFn, decorators) {
  return decorators.reduce(function (decorated, decorator) {
    return function (context) {
      var story;
      var decoratedStory = decorator(function (update) {
        story = decorated(Object.assign({}, context, (0, _store.sanitizeStoryContextUpdate)(update)));
        return story;
      }, context);

      if (!story) {
        story = decorated(context);
      }

      if (decoratedStory === story) {
        return story;
      }

      return prepare(decoratedStory, story);
    };
  }, function (context) {
    return prepare(storyFn(context));
  });
}