import _extends from"@babel/runtime/helpers/extends";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";import React,{useState,useEffect}from"react";import{useTheme}from"@devtools-ds/themes";import makeClass from"clsx";import TreeContext from"./TreeContext";import styles from"./Tree.css";export const Tree=props=>{const{theme,hover,colorScheme,children,label,className,onUpdate,onSelect,open}=props,html=_objectWithoutProperties(props,["theme","hover","colorScheme","children","label","className","onUpdate","onSelect","open"]);const{themeClass,currentTheme}=useTheme({theme,colorScheme},styles);const[isOpen,setOpen]=useState(open);useEffect(()=>{setOpen(open)},[open]);const updateState=value=>{setOpen(value);if(onUpdate)onUpdate(value)};const hasChildren=React.Children.count(children)>0;const updateFocus=(newNode,previousNode)=>{if(newNode.isSameNode(previousNode||null))return;const focusableNode=newNode.querySelector("[tabindex=\"-1\"]");focusableNode===null||focusableNode===void 0?void 0:focusableNode.focus();newNode.setAttribute("aria-selected","true");previousNode===null||previousNode===void 0?void 0:previousNode.removeAttribute("aria-selected")};const getParent=(node,role)=>{let parent=node;while(parent&&parent.parentElement){if(parent.getAttribute("role")===role){return parent}parent=parent.parentElement}return null};const getListElements=node=>{const tree=getParent(node,"tree");if(!tree)return[];return Array.from(tree.querySelectorAll("li"))};const moveBack=node=>{const group=getParent(node,"group");const toggle=group===null||group===void 0?void 0:group.previousElementSibling;if(toggle&&toggle.getAttribute("tabindex")==="-1"){const toggleParent=toggle.parentElement;const nodeParent=node.parentElement;updateFocus(toggleParent,nodeParent)}};const moveHome=(node,direction)=>{const elements=getListElements(node);elements.forEach(element=>{element.removeAttribute("aria-selected")});if(direction==="start"&&elements[0]){updateFocus(elements[0])}if(direction==="end"&&elements[elements.length-1]){updateFocus(elements[elements.length-1])}};const moveFocusAdjacent=(node,direction)=>{const elements=getListElements(node)||[];for(let i=0;i<elements.length;i++){const currentNode=elements[i];if(currentNode.getAttribute("aria-selected")==="true"){if(direction==="up"&&elements[i-1]){updateFocus(elements[i-1],currentNode)}else if(direction==="down"&&elements[i+1]){updateFocus(elements[i+1],currentNode)}return}}updateFocus(elements[0])};const handleKeypress=(event,isChild)=>{const node=event.target;if(event.key==="Enter"||event.key===" "){updateState(!isOpen)}if(event.key==="ArrowRight"&&isOpen&&!isChild){moveFocusAdjacent(node,"down")}else if(event.key==="ArrowRight"){updateState(true)}if(event.key==="ArrowLeft"&&(!isOpen||isChild)){moveBack(node)}else if(event.key==="ArrowLeft"){updateState(false)}if(event.key==="ArrowDown"){moveFocusAdjacent(node,"down")}if(event.key==="ArrowUp"){moveFocusAdjacent(node,"up")}if(event.key==="Home"){moveHome(node,"start")}if(event.key==="End"){moveHome(node,"end")}};const handleClick=(event,isChild)=>{const node=event.target;const parent=getParent(node,"treeitem");const elements=getListElements(node)||[];let found=false;for(let i=0;i<elements.length;i++){const currentNode=elements[i];if(currentNode.getAttribute("aria-selected")==="true"){if(parent){found=true;updateFocus(parent,currentNode)}break}}if(!found&&parent){updateFocus(parent)}if(!isChild){updateState(!isOpen)}};const handleBlur=event=>{const node=event.currentTarget;if(!node.contains(document.activeElement)&&node.getAttribute("role")==="tree"){node.setAttribute("tabindex","0")}};const handleFocus=event=>{const node=event.target;if(node.getAttribute("role")==="tree"){const selected=node.querySelector("[aria-selected=\"true\"]");if(selected){updateFocus(selected)}else{moveFocusAdjacent(node,"down")}node.setAttribute("tabindex","-1")}};const handleButtonFocus=()=>{onSelect===null||onSelect===void 0?void 0:onSelect()};const getPaddingStyles=depth=>{const space=depth*0.9+0.3;return{paddingLeft:`${space}em`,width:`calc(100% - ${space}em)`}};const{isChild,depth,hasHover}=React.useContext(TreeContext);const showHover=hasHover?hover:false;if(!isChild){return React.createElement("ul",_extends({role:"tree",tabIndex:0,className:makeClass(styles.tree,styles.group,themeClass,className),onFocus:handleFocus,onBlur:handleBlur},html),React.createElement(TreeContext.Provider,{value:{isChild:true,depth:0,hasHover:showHover}},React.createElement(Tree,props)))}if(!hasChildren){return React.createElement("li",_extends({role:"treeitem",className:styles.item},html),React.createElement("div",{role:"button",className:makeClass(styles.label,{[styles.hover]:showHover,[styles.focusWhite]:currentTheme==="firefox"}),tabIndex:-1,style:getPaddingStyles(depth),onKeyDown:e=>{handleKeypress(e,isChild)},onClick:e=>handleClick(e,true),onFocus:handleButtonFocus},React.createElement("span",null,label)))}const arrowClass=makeClass(styles.arrow,{[styles.open]:isOpen});return React.createElement("li",{role:"treeitem","aria-expanded":isOpen,className:styles.item},React.createElement("div",{role:"button",tabIndex:-1,className:makeClass(styles.label,{[styles.hover]:showHover,[styles.focusWhite]:currentTheme==="firefox"}),style:getPaddingStyles(depth),onClick:e=>handleClick(e),onKeyDown:e=>handleKeypress(e),onFocus:handleButtonFocus},React.createElement("span",null,React.createElement("span",{"aria-hidden":true,className:arrowClass}),React.createElement("span",null,label))),React.createElement("ul",_extends({role:"group",className:makeClass(className,styles.group)},html),isOpen&&React.Children.map(children,child=>{return React.createElement(TreeContext.Provider,{value:{isChild:true,depth:depth+1,hasHover:showHover}},child)})))};Tree.defaultProps={open:false,hover:true};
//# sourceMappingURL=index.js.map
import "../main.css";