"use strict";var _interopRequireWildcard=require("@babel/runtime/helpers/interopRequireWildcard");var _interopRequireDefault=require("@babel/runtime/helpers/interopRequireDefault");Object.defineProperty(exports,"__esModule",{value:true});exports.Tree=void 0;var _extends2=_interopRequireDefault(require("@babel/runtime/helpers/extends"));var _objectWithoutProperties2=_interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));var _react=_interopRequireWildcard(require("react"));var _themes=require("@devtools-ds/themes");var _clsx=_interopRequireDefault(require("clsx"));var _TreeContext=_interopRequireDefault(require("./TreeContext"));var _Tree=_interopRequireDefault(require("./Tree.css"));const Tree=props=>{const{theme,hover,colorScheme,children,label,className,onUpdate,onSelect,open}=props,html=(0,_objectWithoutProperties2.default)(props,["theme","hover","colorScheme","children","label","className","onUpdate","onSelect","open"]);const{themeClass,currentTheme}=(0,_themes.useTheme)({theme,colorScheme},_Tree.default);const[isOpen,setOpen]=(0,_react.useState)(open);(0,_react.useEffect)(()=>{setOpen(open)},[open]);const updateState=value=>{setOpen(value);if(onUpdate)onUpdate(value)};const hasChildren=_react.default.Children.count(children)>0;const updateFocus=(newNode,previousNode)=>{if(newNode.isSameNode(previousNode||null))return;const focusableNode=newNode.querySelector("[tabindex=\"-1\"]");focusableNode===null||focusableNode===void 0?void 0:focusableNode.focus();newNode.setAttribute("aria-selected","true");previousNode===null||previousNode===void 0?void 0:previousNode.removeAttribute("aria-selected")};const getParent=(node,role)=>{let parent=node;while(parent&&parent.parentElement){if(parent.getAttribute("role")===role){return parent}parent=parent.parentElement}return null};const getListElements=node=>{const tree=getParent(node,"tree");if(!tree)return[];return Array.from(tree.querySelectorAll("li"))};const moveBack=node=>{const group=getParent(node,"group");const toggle=group===null||group===void 0?void 0:group.previousElementSibling;if(toggle&&toggle.getAttribute("tabindex")==="-1"){const toggleParent=toggle.parentElement;const nodeParent=node.parentElement;updateFocus(toggleParent,nodeParent)}};const moveHome=(node,direction)=>{const elements=getListElements(node);elements.forEach(element=>{element.removeAttribute("aria-selected")});if(direction==="start"&&elements[0]){updateFocus(elements[0])}if(direction==="end"&&elements[elements.length-1]){updateFocus(elements[elements.length-1])}};const moveFocusAdjacent=(node,direction)=>{const elements=getListElements(node)||[];for(let i=0;i<elements.length;i++){const currentNode=elements[i];if(currentNode.getAttribute("aria-selected")==="true"){if(direction==="up"&&elements[i-1]){updateFocus(elements[i-1],currentNode)}else if(direction==="down"&&elements[i+1]){updateFocus(elements[i+1],currentNode)}return}}updateFocus(elements[0])};const handleKeypress=(event,isChild)=>{const node=event.target;if(event.key==="Enter"||event.key===" "){updateState(!isOpen)}if(event.key==="ArrowRight"&&isOpen&&!isChild){moveFocusAdjacent(node,"down")}else if(event.key==="ArrowRight"){updateState(true)}if(event.key==="ArrowLeft"&&(!isOpen||isChild)){moveBack(node)}else if(event.key==="ArrowLeft"){updateState(false)}if(event.key==="ArrowDown"){moveFocusAdjacent(node,"down")}if(event.key==="ArrowUp"){moveFocusAdjacent(node,"up")}if(event.key==="Home"){moveHome(node,"start")}if(event.key==="End"){moveHome(node,"end")}};const handleClick=(event,isChild)=>{const node=event.target;const parent=getParent(node,"treeitem");const elements=getListElements(node)||[];let found=false;for(let i=0;i<elements.length;i++){const currentNode=elements[i];if(currentNode.getAttribute("aria-selected")==="true"){if(parent){found=true;updateFocus(parent,currentNode)}break}}if(!found&&parent){updateFocus(parent)}if(!isChild){updateState(!isOpen)}};const handleBlur=event=>{const node=event.currentTarget;if(!node.contains(document.activeElement)&&node.getAttribute("role")==="tree"){node.setAttribute("tabindex","0")}};const handleFocus=event=>{const node=event.target;if(node.getAttribute("role")==="tree"){const selected=node.querySelector("[aria-selected=\"true\"]");if(selected){updateFocus(selected)}else{moveFocusAdjacent(node,"down")}node.setAttribute("tabindex","-1")}};const handleButtonFocus=()=>{onSelect===null||onSelect===void 0?void 0:onSelect()};const getPaddingStyles=depth=>{const space=depth*0.9+0.3;return{paddingLeft:`${space}em`,width:`calc(100% - ${space}em)`}};const{isChild,depth,hasHover}=_react.default.useContext(_TreeContext.default);const showHover=hasHover?hover:false;if(!isChild){return _react.default.createElement("ul",(0,_extends2.default)({role:"tree",tabIndex:0,className:(0,_clsx.default)(_Tree.default.tree,_Tree.default.group,themeClass,className),onFocus:handleFocus,onBlur:handleBlur},html),_react.default.createElement(_TreeContext.default.Provider,{value:{isChild:true,depth:0,hasHover:showHover}},_react.default.createElement(Tree,props)))}if(!hasChildren){return _react.default.createElement("li",(0,_extends2.default)({role:"treeitem",className:_Tree.default.item},html),_react.default.createElement("div",{role:"button",className:(0,_clsx.default)(_Tree.default.label,{[_Tree.default.hover]:showHover,[_Tree.default.focusWhite]:currentTheme==="firefox"}),tabIndex:-1,style:getPaddingStyles(depth),onKeyDown:e=>{handleKeypress(e,isChild)},onClick:e=>handleClick(e,true),onFocus:handleButtonFocus},_react.default.createElement("span",null,label)))}const arrowClass=(0,_clsx.default)(_Tree.default.arrow,{[_Tree.default.open]:isOpen});return _react.default.createElement("li",{role:"treeitem","aria-expanded":isOpen,className:_Tree.default.item},_react.default.createElement("div",{role:"button",tabIndex:-1,className:(0,_clsx.default)(_Tree.default.label,{[_Tree.default.hover]:showHover,[_Tree.default.focusWhite]:currentTheme==="firefox"}),style:getPaddingStyles(depth),onClick:e=>handleClick(e),onKeyDown:e=>handleKeypress(e),onFocus:handleButtonFocus},_react.default.createElement("span",null,_react.default.createElement("span",{"aria-hidden":true,className:arrowClass}),_react.default.createElement("span",null,label))),_react.default.createElement("ul",(0,_extends2.default)({role:"group",className:(0,_clsx.default)(className,_Tree.default.group)},html),isOpen&&_react.default.Children.map(children,child=>{return _react.default.createElement(_TreeContext.default.Provider,{value:{isChild:true,depth:depth+1,hasHover:showHover}},child)})))};exports.Tree=Tree;Tree.defaultProps={open:false,hover:true};
//# sourceMappingURL=index.js.map