export const chrome = {
  light: {
    backgroundColor: "#FFFFFF",
    textColor: "#303942",
    error: "#EC3941",
    errorBorder: "#FED7D6",
    errorBackground: "#FEF1F0",
    errorText: "#FF0000",
    warning: "#F5BD00",
    warningBorder: "#FFF5C2",
    warningBackground: "#FFFBE5",
    warningText: "#5C3D00",
    gray01: "#F3F3F3",
    gray02: "#E9E9E9",
    gray03: "#CDCDCD",
    gray04: "#C0C0C0",
    gray05: "#8E8E8E",
    gray06: "#444444",
    blue01: "#EDF2FC",
    blue02: "#CFE8FC",
    blue03: "#1A73E8",
    blue04: "#3646B6",
    blue05: "#2D0BC9",
    green01: "#317632",
    red01: "#CF4B49",
    purple01: "#AE97BB",
    purple02: "#BD84C2",
    purple03: "#881280",
    brown01: "#994400",
  },
  dark: {
    backgroundColor: "#252525",
    textColor: "#EDEEEE",
    error: "#EC3941",
    errorBorder: "#5C0100",
    errorBackground: "#290000",
    errorText: "#FD7E7E",
    warning: "#F5BD00",
    warningBorder: "#665500",
    warningBackground: "#332B00",
    warningText: "#FDFCF8",
    gray01: "#C8C8C8",
    gray02: "#B7B7B7",
    gray03: "#848484",
    gray04: "#3C3D3C",
    gray05: "#2A2A2D",
    gray06: "#202020",
    blue01: "#9ABBDB",
    blue02: "#59A6C9",
    blue03: "#0E639C",
    blue04: "#093D69",
    blue05: "#192538",
    orange01: "#F29766",
    orange02: "#EE8953",
    pink01: "#F6D9F8",
    pink02: "#AB98AC",
    purple01: "#D0D6FB",
    purple02: "#987FFD",
  },
};

export const firefox = {
  light: {
    backgroundColor: "#FFFFFF",
    textColor: "#47474C",
    error: "#EA000E",
    errorBorder: "#FFD3DB",
    errorBackground: "#FFF1F5",
    errorText: "#B30000",
    warning: "#C5A500",
    warningBorder: "#F5EBA4",
    warningBackground: "#FFFCDB",
    warningText: "#7C5B00",
    gray01: "#FAFAFA",
    gray02: "#E9E9E9",
    gray03: "#BEBEC0",
    gray04: "#6A6A6A",
    gray05: "#575757",
    gray06: "#181818",
    blue01: "#F2FAFE",
    blue02: "#DFEFFF",
    blue03: "#007FEB",
    blue04: "#0A66E6",
    blue05: "#034AB4",
    green01: "#049600",
    green02: "#117C04",
    pink01: "#E51EBB",
    purple01: "#8304d7",
  },
  dark: {
    backgroundColor: "#232327",
    textColor: "#BABABB",
    error: "#FF0768",
    errorBorder: "#7C3A4C",
    errorBackground: "#502D36",
    errorText: "#FFAED3",
    warning: "#DCBE00",
    warningBorder: "#616134",
    warningBackground: "#4B4022",
    warningText: "#ECD79E",
    gray01: "#9D9D9E",
    gray02: "#404046",
    gray03: "#343439",
    gray04: "#27272C",
    gray05: "#18181A",
    gray06: "#0C0C0D",
    blue01: "#80C6FF",
    blue02: "#6FB9FF",
    blue03: "#5DC0FF",
    blue04: "#0A84FF",
    blue05: "#235895",
    green01: "#91E27F",
    green02: "#81DF6C",
    pink01: "#FF88EC",
    pink02: "#EB7ED9",
    purple01: "#C288FF",
  },
} as const;

export const all = { chrome, firefox };
