"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=exports.parse=exports.getPromiseState=exports.isKnownObject=exports.isObject=void 0;const isArray=val=>{return Array.isArray(val)||ArrayBuffer.isView(val)&&!(val instanceof DataView)};const isObject=val=>{return val!==null&&typeof val==="object"&&!isArray(val)&&!(val instanceof Date)&&!(val instanceof RegExp)&&!(val instanceof Error)&&!(val instanceof WeakMap)&&!(val instanceof WeakSet)};exports.isObject=isObject;const isKnownObject=val=>{return isObject(val)||isArray(val)||typeof val==="function"||val instanceof Promise};exports.isKnownObject=isKnownObject;const getPromiseState=promise=>{const unique=/unique/;return Promise.race([promise,unique]).then(result=>result===unique?["pending"]:["fulfilled",result],e=>["rejected",e])};exports.getPromiseState=getPromiseState;const buildAST=async(key,value,depth,sortKeys,isPrototype,showPrototype)=>{const astNode={key,depth,value,type:"value",parent:undefined};if(value&&isKnownObject(value)&&depth<100){const children=[];let t="object";if(isArray(value)){for(let i=0;i<value.length;i++){children.push(async()=>{const child=await buildAST(i.toString(),value[i],depth+1,sortKeys);child.parent=astNode;return child})}t="array"}else{const keys=Object.getOwnPropertyNames(value);if(sortKeys)keys.sort();for(let i=0;i<keys.length;i++){let safeValue;try{safeValue=value[keys[i]]}catch(e){}children.push(async()=>{const child=await buildAST(keys[i],safeValue,depth+1,sortKeys);child.parent=astNode;return child})}if(typeof value==="function"){t="function"}if(value instanceof Promise){const[status,result]=await getPromiseState(value);children.push(async()=>{const child=await buildAST("<state>",status,depth+1,sortKeys);child.parent=astNode;return child});if(status!=="pending"){children.push(async()=>{const child=await buildAST("<value>",result,depth+1,sortKeys);child.parent=astNode;return child})}t="promise"}if(value instanceof Map){const entries=Array.from(value.entries());const parsedEntries=entries.map(entry=>{const[entryKey,entryValue]=entry;return{"<key>":entryKey,"<value>":entryValue}});children.push(async()=>{const child=await buildAST("<entries>",parsedEntries,depth+1,sortKeys);child.parent=astNode;return child});children.push(async()=>{const child=await buildAST("size",value.size,depth+1,sortKeys);child.parent=astNode;return child});t="map"}if(value instanceof Set){const entries=Array.from(value.entries());const parsedEntries=entries.map(entry=>{return entry[1]});children.push(async()=>{const child=await buildAST("<entries>",parsedEntries,depth+1,sortKeys);child.parent=astNode;return child});children.push(async()=>{const child=await buildAST("size",value.size,depth+1,sortKeys);child.parent=astNode;return child});t="set"}}if(value!==Object.prototype&&showPrototype){children.push(async()=>{const child=await buildAST("<prototype>",Object.getPrototypeOf(value),depth+1,sortKeys,true);child.parent=astNode;return child})}astNode.type=t;astNode.children=children;astNode.isPrototype=isPrototype}return astNode};const parse=(data,sortKeys,includePrototypes)=>{const keys=sortKeys===false?sortKeys:true;const prototypes=includePrototypes===false?includePrototypes:true;return buildAST("root",data,0,keys,undefined,prototypes)};exports.parse=parse;var _default=parse;exports.default=_default;
//# sourceMappingURL=index.js.map