import _extends from"@babel/runtime/helpers/extends";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";import React from"react";import makeClass from"clsx";import{useTheme}from"@devtools-ds/themes";import ObjectValue from"./ObjectValue";import styles from"./ObjectInspector.css";const buildPreview=(children,previewMax,showKey)=>{const previews=[];for(let i=0;i<children.length;i++){const child=children[i];if(!child.isPrototype){previews.push(React.createElement(ObjectValue,{key:child.key,ast:child,showKey:showKey}));if(i<children.length-1){previews.push(", ")}else{previews.push(" ")}}if(child.isPrototype&&i===children.length-1){previews.pop();previews.push(" ")}if(i===previewMax-1&&children.length>previewMax){previews.push("\u2026 ");break}}return previews};const getArrayLabel=(ast,open,previewMax,theme)=>{const l=ast.value.length;if(open){return React.createElement("span",null,"Array(",l,")")}return React.createElement(React.Fragment,null,React.createElement("span",null,`${theme==="firefox"?"Array":""}(${l}) [ `),buildPreview(ast.children,previewMax,false),React.createElement("span",null,"]"))};const getObjectLabel=(ast,open,previewMax,theme)=>{if(ast.isPrototype){return React.createElement("span",null,`Object ${theme==="firefox"?"{ \u2026 }":""}`)}if(open){return React.createElement("span",null,"{\u2026}")}return React.createElement(React.Fragment,null,React.createElement("span",null,`${theme==="firefox"?"Object ":""}{ `),buildPreview(ast.children,previewMax,true),React.createElement("span",null,"}"))};const getPromiseLabel=(ast,open,previewMax)=>{if(open){return React.createElement("span",null,`Promise { "${String(ast.children[0].value)}" }`)}return React.createElement(React.Fragment,null,React.createElement("span",null,`Promise { `),buildPreview(ast.children,previewMax,true),React.createElement("span",null,"}"))};const getMapLabel=(ast,open,previewMax,theme)=>{const{size}=ast.value;if(open){return React.createElement("span",null,`Map(${size})`)}return React.createElement(React.Fragment,null,React.createElement("span",null,`Map${theme==="chrome"?`(${size})`:""} { `),buildPreview(ast.children,previewMax,true),React.createElement("span",null,"}"))};const getSetLabel=(ast,open,previewMax)=>{const{size}=ast.value;if(open){return React.createElement("span",null,"Set(",size,")")}return React.createElement(React.Fragment,null,React.createElement("span",null,`Set(${ast.value.size}) {`),buildPreview(ast.children,previewMax,true),React.createElement("span",null,"}"))};export const ObjectLabel=props=>{const{ast,theme,previewMax,open,colorScheme,className}=props,html=_objectWithoutProperties(props,["ast","theme","previewMax","open","colorScheme","className"]);const{themeClass,currentTheme}=useTheme({theme,colorScheme},styles);const isPrototype=ast.isPrototype||false;const classes=makeClass(styles.objectLabel,themeClass,className,{[styles.prototype]:isPrototype});const isRoot=ast.depth<=0;const Key=()=>{return React.createElement("span",{className:isPrototype?styles.prototype:styles.key},isRoot?"":`${ast.key}: `)};if(ast.type==="array"){return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),getArrayLabel(ast,open,previewMax,currentTheme))}if(ast.type==="function"){return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),currentTheme==="chrome"&&React.createElement("span",{className:styles.functionDecorator},"\u0192 "),React.createElement("span",{className:makeClass({[styles.function]:!isPrototype})},`${ast.value.name}()`))}if(ast.type==="promise"){return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),getPromiseLabel(ast,open,previewMax))}if(ast.type==="map"){return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),getMapLabel(ast,open,previewMax,currentTheme))}if(ast.type==="set"){return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),getSetLabel(ast,open,previewMax))}return React.createElement("span",_extends({className:classes},html),React.createElement(Key,null),getObjectLabel(ast,open,previewMax,currentTheme))};ObjectLabel.defaultProps={previewMax:8,open:false};export default ObjectLabel;
//# sourceMappingURL=ObjectLabel.js.map