package rtu.schema

import org.apache.spark.sql.types.{IntegerType, StringType, StructType, TimestampType, DoubleType}

object RTUFileSchema {
  val schema_data = new StructType()
    .add("ID", StringType, true)
    .add("DEVICE_ID", StringType, true)
    .add("RESOURCE_URI", StringType, true)
    .add("RESOURCE_NAME", StringType, true)
    .add("RESOURCE_VALUE", IntegerType, true)
    .add("IS_CHANGED", IntegerType, true)
    .add("EVENT_TYPE", IntegerType, true)
    .add("CREATE_TIME", TimestampType, true)
    .add("UPDATE_TIME", TimestampType, true)
    .add("DATA_TIME", TimestampType, true)


  val schema_info = new StructType()
    .add("company", StringType, true)
    .add("name", StringType, true)
    .add("location", StringType, true)
    .add("energy", StringType, true)
    .add("panel_model", StringType, true)
    .add("panel_manufacturer", StringType, true)
    .add("inverter_model", StringType, true)
    .add("inverter_manufacturer", StringType, true)
    .add("panel_count", IntegerType, true)
    .add("inverter_count", IntegerType, true)
    .add("gen", DoubleType, true)
    .add("device_id", StringType, true)
    .add("v_device_id", StringType, true)
    .add("address", StringType, true)
    .add("cido", StringType, true)
    .add("sigugun", StringType, true)
    .add("dongcode", StringType, true)
    .add("dong", StringType, true)
    .add("flg", IntegerType, true)
    .add("customer_id", IntegerType, true)
    .add("install_rtu_count", IntegerType, true)
}
