/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MongoRelationHelper$ {
    public static MongoRelationHelper$ MODULE$;

    static {
        new MongoRelationHelper$();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Bson> createPipeline(String[] requiredColumns, Filter[] filters) {
        void var3_3;
        block1: {
            Nil$ pipeline = Nil$.MODULE$;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).nonEmpty()) {
                Bson bson = Aggregates.project((Bson)this.createProjection(requiredColumns));
                pipeline = pipeline.$colon$colon((Object)bson);
            }
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).nonEmpty()) break block1;
            Bson bson = Aggregates.match((Bson)this.createMatch(filters));
            pipeline = pipeline.$colon$colon((Object)bson);
        }
        return var3_3;
    }

    private Bson createMatch(Filter[] filters) {
        Bson[] matchPipelineStage = (Bson[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Bson bson;
            Filter filter = x0$1;
            if (filter instanceof EqualTo) {
                EqualTo equalTo = (EqualTo)filter;
                String field = equalTo.attribute();
                Object value = equalTo.value();
                bson = Filters.eq((String)field, (Object)value);
            } else if (filter instanceof EqualNullSafe) {
                EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
                String field = equalNullSafe.attribute();
                Object value = equalNullSafe.value();
                bson = Filters.eq((String)field, (Object)value);
            } else if (filter instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)filter;
                String field = greaterThan.attribute();
                Object value = greaterThan.value();
                bson = Filters.gt((String)field, (Object)value);
            } else if (filter instanceof GreaterThanOrEqual) {
                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
                String field = greaterThanOrEqual.attribute();
                Object value = greaterThanOrEqual.value();
                bson = Filters.gte((String)field, (Object)value);
            } else if (filter instanceof In) {
                In in = (In)filter;
                String field = in.attribute();
                Object[] values = in.values();
                bson = Filters.in((String)field, (Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps((Object)values).toList()).asJava()));
            } else if (filter instanceof LessThan) {
                LessThan lessThan = (LessThan)filter;
                String field = lessThan.attribute();
                Object value = lessThan.value();
                bson = Filters.lt((String)field, (Object)value);
            } else if (filter instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
                String field = lessThanOrEqual.attribute();
                Object value = lessThanOrEqual.value();
                bson = Filters.lte((String)field, (Object)value);
            } else if (filter instanceof IsNull) {
                IsNull isNull = (IsNull)filter;
                String field = isNull.attribute();
                bson = Filters.eq((String)field, null);
            } else if (filter instanceof IsNotNull) {
                IsNotNull isNotNull = (IsNotNull)filter;
                String field = isNotNull.attribute();
                bson = BsonDocument.parse((String)new StringBuilder(36).append("{\"").append(field).append("\": {\"$exists\": true, \"$ne\": null}}").toString());
            } else if (filter instanceof And) {
                And and = (And)filter;
                Filter leftFilter = and.left();
                Filter rightFilter = and.right();
                bson = Filters.and((Bson[])new Bson[]{MODULE$.createMatch((Filter[])((Object[])new Filter[]{leftFilter})), MODULE$.createMatch((Filter[])((Object[])new Filter[]{rightFilter}))});
            } else if (filter instanceof Or) {
                Or or = (Or)filter;
                Filter leftFilter = or.left();
                Filter rightFilter = or.right();
                bson = Filters.or((Bson[])new Bson[]{MODULE$.createMatch((Filter[])((Object[])new Filter[]{leftFilter})), MODULE$.createMatch((Filter[])((Object[])new Filter[]{rightFilter}))});
            } else if (filter instanceof Not) {
                Not not = (Not)filter;
                Filter filter2 = not.child();
                bson = Filters.not((Bson)MODULE$.createMatch((Filter[])((Object[])new Filter[]{filter2})));
            } else if (filter instanceof StringStartsWith) {
                StringStartsWith stringStartsWith = (StringStartsWith)filter;
                String field = stringStartsWith.attribute();
                String value = stringStartsWith.value();
                bson = Filters.regex((String)field, (Pattern)Pattern.compile(new StringBuilder(1).append("^").append(value).toString()));
            } else if (filter instanceof StringEndsWith) {
                StringEndsWith stringEndsWith = (StringEndsWith)filter;
                String field = stringEndsWith.attribute();
                String value = stringEndsWith.value();
                bson = Filters.regex((String)field, (Pattern)Pattern.compile(new StringBuilder(1).append(value).append("$").toString()));
            } else if (filter instanceof StringContains) {
                StringContains stringContains = (StringContains)filter;
                String field = stringContains.attribute();
                String value = stringContains.value();
                bson = Filters.regex((String)field, (Pattern)Pattern.compile(value));
            } else {
                throw new MatchError((Object)filter);
            }
            return bson;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Bson.class)));
        return matchPipelineStage.length > 1 ? Filters.and((Bson[])matchPipelineStage) : (Bson)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchPipelineStage)).head();
    }

    private Bson createProjection(String[] requiredColumns) {
        Bson bson;
        boolean bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).contains((Object)"_id");
        if (bl) {
            bson = Projections.include((String[])requiredColumns);
        } else if (!bl) {
            BsonDocument projections = new BsonDocument();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)x$3 -> projections.append(x$3, (BsonValue)new BsonInt32(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BsonDocument.class)));
            bson = projections.append("_id", (BsonValue)new BsonInt32(0));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return bson;
    }

    private MongoRelationHelper$() {
        MODULE$ = this;
    }
}

