/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.DefaultHelper$DefaultsTo$;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.MongoSpark$;
import com.mongodb.spark.config.AggregationConfig;
import com.mongodb.spark.config.ReadConcernConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadPreferenceConfig;
import com.mongodb.spark.rdd.MongoRDD;
import com.mongodb.spark.rdd.partitioner.MongoSinglePartitioner$;
import com.mongodb.spark.sql.MongoInferSchemaJava;
import com.mongodb.spark.sql.types.BsonCompatibility$Binary$;
import com.mongodb.spark.sql.types.BsonCompatibility$DbPointer$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScript$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScriptWithScope$;
import com.mongodb.spark.sql.types.BsonCompatibility$MaxKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$MinKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$ObjectId$;
import com.mongodb.spark.sql.types.BsonCompatibility$RegularExpression$;
import com.mongodb.spark.sql.types.BsonCompatibility$Symbol$;
import com.mongodb.spark.sql.types.BsonCompatibility$Timestamp$;
import com.mongodb.spark.sql.types.BsonCompatibility$Undefined$;
import com.mongodb.spark.sql.types.ConflictType;
import com.mongodb.spark.sql.types.ConflictType$;
import com.mongodb.spark.sql.types.SkipFieldType;
import com.mongodb.spark.sql.types.SkipFieldType$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MongoInferSchema$
extends Logging {
    public static MongoInferSchema$ MODULE$;
    private final Seq<NumericType> compatibleDecimalTypes;
    private final DecimalType ByteDecimal;
    private final DecimalType ShortDecimal;
    private final DecimalType IntDecimal;
    private final DecimalType LongDecimal;
    private final DecimalType FloatDecimal;
    private final DecimalType DoubleDecimal;
    private final DecimalType BigIntDecimal;
    private final StructField[] emptyStructFieldArray;
    private final Comparator<StructField> structFieldComparator;

    static {
        new MongoInferSchema$();
    }

    public StructType apply(SparkContext sc) {
        return this.apply(MongoSpark$.MODULE$.load(sc, ClassTag$.MODULE$.apply(BsonDocument.class), DefaultHelper$DefaultsTo$.MODULE$.overrideDefault()));
    }

    public StructType apply(MongoRDD<BsonDocument> mongoRDD) {
        StructType structType;
        Some some;
        DataType st;
        MongoRDD<BsonDocument> mongoRDD2;
        MongoSinglePartitioner$ x$1 = MongoSinglePartitioner$.MODULE$;
        String x$22 = mongoRDD.readConfig().copy$default$1();
        String x$32 = mongoRDD.readConfig().copy$default$2();
        Option<String> x$42 = mongoRDD.readConfig().copy$default$3();
        int x$52 = mongoRDD.readConfig().copy$default$4();
        Map<String, String> x$62 = mongoRDD.readConfig().copy$default$6();
        int x$7 = mongoRDD.readConfig().copy$default$7();
        ReadPreferenceConfig x$8 = mongoRDD.readConfig().copy$default$8();
        ReadConcernConfig x$9 = mongoRDD.readConfig().copy$default$9();
        AggregationConfig x$10 = mongoRDD.readConfig().copy$default$10();
        boolean x$11 = mongoRDD.readConfig().copy$default$11();
        boolean x$12 = mongoRDD.readConfig().copy$default$12();
        int x$13 = mongoRDD.readConfig().copy$default$13();
        boolean x$14 = mongoRDD.readConfig().copy$default$14();
        boolean x$15 = mongoRDD.readConfig().copy$default$15();
        int x$16 = mongoRDD.readConfig().copy$default$16();
        Option<Object> x$17 = mongoRDD.readConfig().copy$default$17();
        ReadConfig x$18 = mongoRDD.readConfig().copy(x$22, x$32, x$42, x$52, x$1, x$62, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        Broadcast<MongoConnector> x$19 = mongoRDD.copy$default$1();
        MongoRDD<BsonDocument> singlePartitionRDD = mongoRDD.copy(x$19, x$18);
        int samplePoolSize = singlePartitionRDD.readConfig().samplePoolSize();
        int sampleSize = singlePartitionRDD.readConfig().sampleSize();
        if (singlePartitionRDD.hasSampleAggregateOperator()) {
            Seq appendedPipeline = singlePartitionRDD.readConfig().pipeline().isEmpty() || samplePoolSize < 0 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.sample((int)sampleSize)})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.limit((int)samplePoolSize), Aggregates.sample((int)sampleSize)}));
            mongoRDD2 = singlePartitionRDD.appendPipeline(appendedPipeline);
        } else {
            long x$222;
            int x$21;
            boolean x$20;
            MongoRDD<BsonDocument> qual$1 = singlePartitionRDD.appendPipeline((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.project((Bson)Projections.include((String[])new String[]{"_id"})), Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"_id"})), Aggregates.limit((int)samplePoolSize)})));
            Seq sampleData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.takeSample(x$20 = false, x$21 = sampleSize, x$222 = qual$1.takeSample$default$3()))).toSeq();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)sampleData.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get((Object)"_id"), Seq$.MODULE$.canBuildFrom())).asJava());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException("The RDD must contain documents that include an '_id' key to infer data when using MongoDB < 3.2");
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            List _ids = (List)success.value();
            MongoRDD<BsonDocument> mongoRDD3 = singlePartitionRDD.appendPipeline((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Aggregates.match((Bson)Filters.in((String)"_id", (java.lang.Iterable)_ids))})));
            mongoRDD2 = mongoRDD3;
        }
        MongoRDD<BsonDocument> sampleData = mongoRDD2;
        RDD qual$2 = sampleData.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.getSchemaFromDocument((BsonDocument)x$2, mongoRDD.readConfig()), ClassTag$.MODULE$.apply(StructType.class));
        StructType x$23 = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function2 & Serializable & scala.Serializable x$24 = (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> MODULE$.compatibleType((DataType)x$3, (DataType)x$4, mongoRDD.readConfig(), false);
        Function2 & Serializable & scala.Serializable x$25 = (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> MODULE$.compatibleType((DataType)x$5, (DataType)x$6, mongoRDD.readConfig(), false);
        int x$26 = qual$2.treeAggregate$default$4((Object)x$23);
        DataType rootType = (DataType)qual$2.treeAggregate((Object)x$23, (Function2)x$24, (Function2)x$25, x$26, ClassTag$.MODULE$.apply(DataType.class));
        Option option = (Option)this.canonicalizeType().apply((Object)rootType);
        StructType structType2 = option instanceof Some && (st = (DataType)(some = (Some)option).value()) instanceof StructType ? (structType = (StructType)st) : StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        return structType2;
    }

    private Function1<DataType, Option<DataType>> canonicalizeType() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            DataType dataType = x0$1;
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                object = ((Option)MODULE$.canonicalizeType().apply((Object)elementType)).map((Function1 & Serializable & scala.Serializable)dt -> arrayType.copy(dt, arrayType.copy$default$2()));
            } else {
                StructType structType;
                StructField[] fields;
                StructField[] canonicalFields;
                object = dataType instanceof StructType ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).flatMap((Function1 & Serializable & scala.Serializable)field -> {
                    Iterable iterable;
                    block5: {
                        block4: {
                            if (field.name().isEmpty()) break block4;
                            DataType dataType = field.dataType();
                            SkipFieldType$ skipFieldType$ = SkipFieldType$.MODULE$;
                            if (dataType != null ? !dataType.equals((Object)skipFieldType$) : skipFieldType$ != null) break block5;
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        return iterable;
                    }
                    if (MODULE$.fieldContainsConflictType(field.dataType())) {
                        String start = field.dataType() instanceof ArrayType ? "Array Field" : "Field";
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append(start).append(" '").append(field.name()).append("' contains conflicting types converting to StringType").toString());
                    }
                    iterable = Option$.MODULE$.option2Iterable(((Option)MODULE$.canonicalizeType().apply((Object)field.dataType())).map((Function1 & Serializable & scala.Serializable)dt -> {
                        DataType x$1 = dt;
                        String x$2 = field.copy$default$1();
                        boolean x$3 = field.copy$default$3();
                        Metadata x$4 = field.copy$default$4();
                        return field.copy(x$2, x$1, x$3, x$4);
                    }));
                    return iterable;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))))).nonEmpty() ? new Some((Object)new StructType(canonicalFields)) : None$.MODULE$) : (dataType instanceof ConflictType ? new Some((Object)StringType$.MODULE$) : new Some((Object)dataType));
            }
            return object;
        };
    }

    private StructType getSchemaFromDocument(BsonDocument document, ReadConfig readConfig) {
        ArrayList fields = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(document.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)fields.add(DataTypes.createStructField((String)((String)kv.getKey()), (DataType)MongoInferSchema$.MODULE$.getDataType((BsonValue)kv.getValue(), readConfig), (boolean)true))));
        return DataTypes.createStructType(fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType compatibleType(DataType t1, DataType t2, ReadConfig readConfig, boolean nested) {
        DataType dataType = (DataType)((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).getOrElse(() -> MongoInferSchema$.$anonfun$compatibleType$1(t1, t2, readConfig));
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof StructType)) return dataType;
        StructType structType = (StructType)dataType2;
        if (!nested) return dataType;
        return this.structTypeToMapType(structType, readConfig);
    }

    private boolean compatibleType$default$4() {
        return true;
    }

    private DataType compatibleStructType(StructField[] fields1, StructField[] fields2, ReadConfig readConfig) {
        scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).groupBy((Function1 & Serializable & scala.Serializable)field -> field.name()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            StructField[] fieldTypes = (StructField[])tuple2._2();
            DataType dataType = (DataType)((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).view().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.dataType(), IndexedSeqView$.MODULE$.arrCanBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> MODULE$.compatibleType((DataType)x$8, (DataType)x$9, readConfig, MODULE$.compatibleType$default$4()));
            StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Iterable$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)newFields.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), (Ordering)Ordering.String$.MODULE$));
    }

    private DataType structTypeToMapType(StructType structType, ReadConfig readConfig) {
        StructType structType2;
        if (readConfig.inferSchemaMapTypesEnabled() && structType.fields().length >= readConfig.inferSchemaMapTypesMinimumKeys()) {
            StructType structType3;
            DataType dataType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> MODULE$.compatibleType((DataType)x$12, (DataType)x$13, readConfig, MODULE$.compatibleType$default$4()));
            if (ConflictType$.MODULE$.equals(dataType)) {
                structType3 = structType;
            } else if (((Object)((Object)SkipFieldType$.MODULE$)).equals(dataType)) {
                structType3 = structType;
            } else if (dataType != null) {
                DataType dataType2 = dataType;
                structType3 = DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)dataType2, (boolean)true);
            } else {
                structType3 = structType;
            }
            structType2 = structType3;
        } else {
            structType2 = structType;
        }
        return structType2;
    }

    private MapType appendStructToMap(StructField[] fields, MapType mapType, ReadConfig readConfig) {
        DataType dataType = mapType.valueType();
        DataType valueType = (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).$plus$colon((Object)dataType, ClassTag$.MODULE$.apply(DataType.class)))).reduce((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> MODULE$.compatibleType((DataType)x$16, (DataType)x$17, readConfig, MODULE$.compatibleType$default$4()));
        return DataTypes.createMapType((DataType)mapType.keyType(), (DataType)valueType, (boolean)mapType.valueContainsNull());
    }

    public Seq<NumericType> compatibleDecimalTypes() {
        return this.compatibleDecimalTypes;
    }

    private DecimalType ByteDecimal() {
        return this.ByteDecimal;
    }

    private DecimalType ShortDecimal() {
        return this.ShortDecimal;
    }

    private DecimalType IntDecimal() {
        return this.IntDecimal;
    }

    private DecimalType LongDecimal() {
        return this.LongDecimal;
    }

    private DecimalType FloatDecimal() {
        return this.FloatDecimal;
    }

    private DecimalType DoubleDecimal() {
        return this.DoubleDecimal;
    }

    private DecimalType BigIntDecimal() {
        return this.BigIntDecimal;
    }

    private DecimalType forType(DataType dataType) {
        DecimalType decimalType;
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            decimalType = this.ByteDecimal();
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            decimalType = this.ShortDecimal();
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            decimalType = this.IntDecimal();
        } else if (LongType$.MODULE$.equals(dataType2)) {
            decimalType = this.LongDecimal();
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            decimalType = this.FloatDecimal();
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            decimalType = this.DoubleDecimal();
        } else {
            throw new MatchError((Object)dataType2);
        }
        return decimalType;
    }

    private StructField[] emptyStructFieldArray() {
        return this.emptyStructFieldArray;
    }

    private Comparator<StructField> structFieldComparator() {
        return this.structFieldComparator;
    }

    private boolean isSorted(StructField[] arr) {
        for (int i = 0; i < arr.length - 1; ++i) {
            if (this.structFieldComparator().compare(arr[i], arr[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    private DataType getDataType(BsonValue bsonValue, ReadConfig readConfig) {
        DataType dataType;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.NULL.equals(bsonType)) {
            dataType = DataTypes.NullType;
        } else if (BsonType.ARRAY.equals(bsonType)) {
            dataType = this.getSchemaFromArray((Seq<BsonValue>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)bsonValue.asArray()).asScala()), readConfig);
        } else if (BsonType.BINARY.equals(bsonType)) {
            dataType = BsonCompatibility$Binary$.MODULE$.getDataType(bsonValue.asBinary());
        } else if (BsonType.BOOLEAN.equals(bsonType)) {
            dataType = DataTypes.BooleanType;
        } else if (BsonType.DATE_TIME.equals(bsonType)) {
            dataType = DataTypes.TimestampType;
        } else if (BsonType.DOCUMENT.equals(bsonType)) {
            dataType = this.getSchemaFromDocument(bsonValue.asDocument(), readConfig);
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            dataType = DataTypes.DoubleType;
        } else if (BsonType.INT32.equals(bsonType)) {
            dataType = DataTypes.IntegerType;
        } else if (BsonType.INT64.equals(bsonType)) {
            dataType = DataTypes.LongType;
        } else if (BsonType.STRING.equals(bsonType)) {
            dataType = DataTypes.StringType;
        } else if (BsonType.OBJECT_ID.equals(bsonType)) {
            dataType = BsonCompatibility$ObjectId$.MODULE$.structType();
        } else if (BsonType.TIMESTAMP.equals(bsonType)) {
            dataType = BsonCompatibility$Timestamp$.MODULE$.structType();
        } else if (BsonType.MIN_KEY.equals(bsonType)) {
            dataType = BsonCompatibility$MinKey$.MODULE$.structType();
        } else if (BsonType.MAX_KEY.equals(bsonType)) {
            dataType = BsonCompatibility$MaxKey$.MODULE$.structType();
        } else if (BsonType.JAVASCRIPT.equals(bsonType)) {
            dataType = BsonCompatibility$JavaScript$.MODULE$.structType();
        } else if (BsonType.JAVASCRIPT_WITH_SCOPE.equals(bsonType)) {
            dataType = BsonCompatibility$JavaScriptWithScope$.MODULE$.structType();
        } else if (BsonType.REGULAR_EXPRESSION.equals(bsonType)) {
            dataType = BsonCompatibility$RegularExpression$.MODULE$.structType();
        } else if (BsonType.UNDEFINED.equals(bsonType)) {
            dataType = BsonCompatibility$Undefined$.MODULE$.structType();
        } else if (BsonType.SYMBOL.equals(bsonType)) {
            dataType = BsonCompatibility$Symbol$.MODULE$.structType();
        } else if (BsonType.DB_POINTER.equals(bsonType)) {
            dataType = BsonCompatibility$DbPointer$.MODULE$.structType();
        } else if (BsonType.DECIMAL128.equals(bsonType)) {
            BigDecimal bigDecimalValue = bsonValue.asDecimal128().decimal128Value().bigDecimalValue();
            int precision = Integer.max(bigDecimalValue.precision(), bigDecimalValue.scale());
            dataType = DataTypes.createDecimalType((int)precision, (int)bigDecimalValue.scale());
        } else {
            dataType = ConflictType$.MODULE$;
        }
        return dataType;
    }

    private DataType getSchemaFromArray(Seq<BsonValue> bsonArray, ReadConfig readConfig) {
        SkipFieldType$ skipFieldType$;
        Seq arrayTypes = (Seq)((SeqLike)bsonArray.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.getBsonType(), Seq$.MODULE$.canBuildFrom())).distinct();
        int n = arrayTypes.length();
        switch (n) {
            case 0: {
                skipFieldType$ = SkipFieldType$.MODULE$;
                break;
            }
            case 1: {
                if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonType[]{BsonType.ARRAY, BsonType.DOCUMENT, BsonType.DECIMAL128}))).contains(arrayTypes.head())) {
                    skipFieldType$ = this.getCompatibleArraySchema(bsonArray, readConfig);
                    break;
                }
                skipFieldType$ = DataTypes.createArrayType((DataType)this.getDataType((BsonValue)bsonArray.head(), readConfig), (boolean)true);
                break;
            }
            default: {
                skipFieldType$ = this.getCompatibleArraySchema(bsonArray, readConfig);
                break;
            }
        }
        return skipFieldType$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fieldContainsConflictType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            DataType elementType;
            ArrayType arrayType = (ArrayType)dataType2;
            DataType dataType3 = elementType = arrayType.elementType();
            ConflictType$ conflictType$ = ConflictType$.MODULE$;
            if (dataType3 == null) {
                if (conflictType$ == null) return true;
            } else if (dataType3.equals(conflictType$)) {
                return true;
            }
        }
        if (!ConflictType$.MODULE$.equals(dataType2)) return false;
        return true;
    }

    public DataType getCompatibleArraySchema(Seq<BsonValue> bsonArray, ReadConfig readConfig) {
        ObjectRef arrayType = ObjectRef.create((Object)new Some((Object)SkipFieldType$.MODULE$));
        bsonArray.takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MongoInferSchema$.$anonfun$getCompatibleArraySchema$1(arrayType, readConfig, x0$1)));
        DataType dataType = (DataType)((Option)arrayType.elem).get();
        SkipFieldType$ skipFieldType$ = ((Object)((Object)SkipFieldType$.MODULE$)).equals(dataType) ? SkipFieldType$.MODULE$ : DataTypes.createArrayType((DataType)dataType, (boolean)true);
        return skipFieldType$;
    }

    public <T extends Product> Option<StructType> reflectSchema(TypeTags.TypeTag<T> evidence$1) {
        Types.TypeApi typeApi;
        Types.TypeApi typeApi2 = typeApi = ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$1);
        Types.TypeApi typeApi3 = ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)package$.MODULE$.universe()).TypeTag().Nothing());
        Object object = !(typeApi2 != null ? !typeApi2.equals(typeApi3) : typeApi3 != null) ? None$.MODULE$ : new Some((Object)((StructType)ScalaReflection$.MODULE$.schemaFor(evidence$1).dataType()));
        return object;
    }

    public <T> StructType reflectSchema(Class<T> beanClass) {
        return MongoInferSchemaJava.reflectSchema(beanClass);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ DataType $anonfun$compatibleType$1(DataType t1$1, DataType t2$1, ReadConfig readConfig$2) {
        block9: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            var5_3 = new Tuple2((Object)t1$1, (Object)t2$1);
                                                            if (var5_3 == null || !DoubleType$.MODULE$.equals(var6_4 = (DataType)var5_3._1()) || !(var5_3._2() instanceof DecimalType)) break block6;
                                                            var4_5 = true;
                                                            break block7;
                                                        }
                                                        if (var5_3 == null) ** GOTO lbl-1000
                                                        var7_6 = (DataType)var5_3._2();
                                                        if (var5_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var7_6)) {
                                                            var4_5 = true;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            var4_5 = false;
                                                        }
                                                    }
                                                    if (!var4_5) break block8;
                                                    var3_7 /* !! */  = DoubleType$.MODULE$;
                                                    break block9;
                                                }
                                                if (var5_3 == null) break block10;
                                                t1 = (DataType)var5_3._1();
                                                t2 = (DataType)var5_3._2();
                                                if (!(t1 instanceof DecimalType)) break block10;
                                                var10_10 = (DecimalType)t1;
                                                if (!(t2 instanceof DecimalType)) break block10;
                                                var11_11 = (DecimalType)t2;
                                                scale = scala.math.package$.MODULE$.max(var10_10.scale(), var11_11.scale());
                                                range = scala.math.package$.MODULE$.max(var10_10.precision() - var10_10.scale(), var11_11.precision() - var11_11.scale());
                                                var3_7 /* !! */  = range + scale > 38 ? DoubleType$.MODULE$ : new DecimalType(range + scale, scale);
                                                break block9;
                                            }
                                            if (var5_3 == null) break block11;
                                            var14_14 = (DataType)var5_3._1();
                                            var15_15 = (DataType)var5_3._2();
                                            if (!(var14_14 instanceof StructType)) break block11;
                                            var16_16 = (StructType)var14_14;
                                            fields1 = var16_16.fields();
                                            if (!(var15_15 instanceof StructType)) break block11;
                                            var18_18 = (StructType)var15_15;
                                            fields2 = var18_18.fields();
                                            var3_7 /* !! */  = MongoInferSchema$.MODULE$.compatibleStructType(fields1, fields2, readConfig$2);
                                            break block9;
                                        }
                                        if (var5_3 == null) break block12;
                                        var20_20 = (DataType)var5_3._1();
                                        var21_21 = (DataType)var5_3._2();
                                        if (!(var20_20 instanceof MapType)) break block12;
                                        var22_22 = (MapType)var20_20;
                                        keyType1 = var22_22.keyType();
                                        valueType1 = var22_22.valueType();
                                        valueContainsNull1 = var22_22.valueContainsNull();
                                        if (!(var21_21 instanceof MapType)) break block12;
                                        var26_26 = (MapType)var21_21;
                                        keyType2 = var26_26.keyType();
                                        valueType2 = var26_26.valueType();
                                        valueContainsNull2 = var26_26.valueContainsNull();
                                        var3_7 /* !! */  = new MapType(MongoInferSchema$.MODULE$.compatibleType(keyType1, keyType2, readConfig$2, MongoInferSchema$.MODULE$.compatibleType$default$4()), MongoInferSchema$.MODULE$.compatibleType(valueType1, valueType2, readConfig$2, MongoInferSchema$.MODULE$.compatibleType$default$4()), valueContainsNull1 != false || valueContainsNull2 != false);
                                        break block9;
                                    }
                                    if (var5_3 == null) break block13;
                                    var30_30 = (DataType)var5_3._1();
                                    mapType = (DataType)var5_3._2();
                                    if (!(var30_30 instanceof StructType)) break block13;
                                    var32_32 = (StructType)var30_30;
                                    fields = var32_32.fields();
                                    if (!(mapType instanceof MapType)) break block13;
                                    var34_34 = (MapType)mapType;
                                    var3_7 /* !! */  = MongoInferSchema$.MODULE$.appendStructToMap(fields, var34_34, readConfig$2);
                                    break block9;
                                }
                                if (var5_3 == null) break block14;
                                mapType = (DataType)var5_3._1();
                                var36_36 = (DataType)var5_3._2();
                                if (!(mapType instanceof MapType)) break block14;
                                var37_37 = (MapType)mapType;
                                if (!(var36_36 instanceof StructType)) break block14;
                                var38_38 = (StructType)var36_36;
                                fields = var38_38.fields();
                                var3_7 /* !! */  = MongoInferSchema$.MODULE$.appendStructToMap(fields, var37_37, readConfig$2);
                                break block9;
                            }
                            if (var5_3 == null) break block15;
                            var40_40 = (DataType)var5_3._1();
                            var41_41 = (DataType)var5_3._2();
                            if (!(var40_40 instanceof ArrayType)) break block15;
                            var42_42 = (ArrayType)var40_40;
                            elementType1 = var42_42.elementType();
                            containsNull1 = var42_42.containsNull();
                            if (!(var41_41 instanceof ArrayType)) break block15;
                            var45_45 = (ArrayType)var41_41;
                            elementType2 = var45_45.elementType();
                            containsNull2 = var45_45.containsNull();
                            var3_7 /* !! */  = new ArrayType(MongoInferSchema$.MODULE$.compatibleType(elementType1, elementType2, readConfig$2, MongoInferSchema$.MODULE$.compatibleType$default$4()), containsNull1 != false || containsNull2 != false);
                            break block9;
                        }
                        if (var5_3 == null) break block16;
                        t1 = (DataType)var5_3._1();
                        t2 = (DataType)var5_3._2();
                        if (t1 == null) break block16;
                        var50_50 = t1;
                        if (!(t2 instanceof DecimalType)) break block16;
                        var51_51 = (DecimalType)t2;
                        if (!MongoInferSchema$.MODULE$.compatibleDecimalTypes().contains((Object)var50_50)) break block16;
                        var3_7 /* !! */  = MongoInferSchema$.MODULE$.compatibleType((DataType)MongoInferSchema$.MODULE$.forType(var50_50), (DataType)var51_51, readConfig$2, MongoInferSchema$.MODULE$.compatibleType$default$4());
                        break block9;
                    }
                    if (var5_3 == null) break block17;
                    t1 = (DataType)var5_3._1();
                    t2 = (DataType)var5_3._2();
                    if (!(t1 instanceof DecimalType)) break block17;
                    var54_54 = (DecimalType)t1;
                    if (t2 == null) break block17;
                    var55_55 = t2;
                    if (!MongoInferSchema$.MODULE$.compatibleDecimalTypes().contains((Object)var55_55)) break block17;
                    var3_7 /* !! */  = MongoInferSchema$.MODULE$.compatibleType((DataType)var54_54, (DataType)MongoInferSchema$.MODULE$.forType(var55_55), readConfig$2, MongoInferSchema$.MODULE$.compatibleType$default$4());
                    break block9;
                }
                if (var5_3 == null) break block18;
                s = (DataType)var5_3._1();
                dataType = (DataType)var5_3._2();
                if (!(s instanceof SkipFieldType) || dataType == null) break block18;
                var58_58 = dataType;
                var3_7 /* !! */  = var58_58;
                break block9;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            dataType = (DataType)var5_3._1();
            s = (DataType)var5_3._2();
            if (dataType == null) ** GOTO lbl-1000
            var61_61 = dataType;
            if (s instanceof SkipFieldType) {
                var3_7 /* !! */  = var61_61;
            } else if (var5_3 != null) {
                var3_7 /* !! */  = ConflictType$.MODULE$;
            } else {
                throw new MatchError((Object)var5_3);
            }
        }
        return var3_7 /* !! */ ;
    }

    public static final /* synthetic */ boolean $anonfun$getCompatibleArraySchema$1(ObjectRef arrayType$1, ReadConfig readConfig$6, BsonValue x0$1) {
        boolean bl;
        BsonValue bsonValue = x0$1;
        if (bsonValue instanceof BsonNull) {
            bl = true;
        } else if (bsonValue != null) {
            BsonValue bsonValue2 = bsonValue;
            Option previous = (Option)arrayType$1.elem;
            arrayType$1.elem = new Some((Object)MODULE$.getDataType(bsonValue2, readConfig$6));
            if (previous.nonEmpty()) {
                Option option = (Option)arrayType$1.elem;
                Option option2 = previous;
                if (option == null ? option2 != null : !option.equals(option2)) {
                    arrayType$1.elem = new Some((Object)MODULE$.compatibleType((DataType)((Option)arrayType$1.elem).get(), (DataType)previous.get(), readConfig$6, MODULE$.compatibleType$default$4()));
                }
            }
            bl = !((Option)arrayType$1.elem).contains((Object)ConflictType$.MODULE$);
        } else {
            throw new MatchError((Object)bsonValue);
        }
        return bl;
    }

    private MongoInferSchema$() {
        MODULE$ = this;
        this.compatibleDecimalTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}));
        this.ByteDecimal = new DecimalType(3, 0);
        this.ShortDecimal = new DecimalType(5, 0);
        this.IntDecimal = new DecimalType(10, 0);
        this.LongDecimal = new DecimalType(20, 0);
        this.FloatDecimal = new DecimalType(14, 7);
        this.DoubleDecimal = new DecimalType(30, 15);
        this.BigIntDecimal = new DecimalType(38, 0);
        this.emptyStructFieldArray = (StructField[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StructField.class));
        this.structFieldComparator = new Comparator<StructField>(){

            public Comparator<StructField> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<StructField> thenComparing(Comparator<? super StructField> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<StructField> thenComparing(Function<? super StructField, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<StructField> thenComparingInt(ToIntFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<StructField> thenComparingLong(ToLongFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<StructField> thenComparingDouble(ToDoubleFunction<? super StructField> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(StructField o1, StructField o2) {
                return new StringOps(Predef$.MODULE$.augmentString(o1.name())).compare(o2.name());
            }
        };
    }
}

