/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql;

import com.mongodb.spark.exceptions.MongoTypeConversionException;
import com.mongodb.spark.sql.BsonValueToJson$;
import com.mongodb.spark.sql.MapFunctions$isBsonNumber$;
import com.mongodb.spark.sql.MapFunctions$notNull$;
import com.mongodb.spark.sql.types.BsonCompatibility$Binary$;
import com.mongodb.spark.sql.types.BsonCompatibility$DbPointer$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScript$;
import com.mongodb.spark.sql.types.BsonCompatibility$JavaScriptWithScope$;
import com.mongodb.spark.sql.types.BsonCompatibility$MaxKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$MinKey$;
import com.mongodb.spark.sql.types.BsonCompatibility$ObjectId$;
import com.mongodb.spark.sql.types.BsonCompatibility$RegularExpression$;
import com.mongodb.spark.sql.types.BsonCompatibility$Symbol$;
import com.mongodb.spark.sql.types.BsonCompatibility$Timestamp$;
import com.mongodb.spark.sql.types.BsonCompatibility$Undefined$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MapFunctions$ {
    public static MapFunctions$ MODULE$;

    static {
        new MapFunctions$();
    }

    public Row documentToRow(BsonDocument bsonDocument, StructType schema, String[] requiredColumns) {
        Tuple2[] tuple2Array;
        Tuple2[] values = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Tuple2 tuple2;
            boolean bl = bsonDocument.containsKey((Object)field.name());
            if (bl) {
                tuple2 = new Tuple2(MODULE$.convertToDataType(bsonDocument.get((Object)field.name()), field.dataType()), field);
            } else if (!bl) {
                tuple2 = new Tuple2(null, field);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).nonEmpty();
        if (bl) {
            scala.collection.immutable.Map requiredValueMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).collect((PartialFunction)new scala.Serializable(requiredColumns){
                public static final long serialVersionUID = 0L;
                private final String[] requiredColumns$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Object, StructField>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Object rowValue = A1._1();
                        StructField rowField = (StructField)A1._2();
                        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1)).contains((Object)rowField.name())) {
                            object = new Tuple2((Object)rowField.name(), (Object)new Tuple2(rowValue, (Object)rowField));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<Object, StructField> x1) {
                    Tuple2<Object, StructField> tuple2 = x1;
                    if (tuple2 == null) return false;
                    StructField rowField = (StructField)tuple2._2();
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.requiredColumns$1)).contains((Object)rowField.name())) return false;
                    return true;
                }
                {
                    this.requiredColumns$1 = requiredColumns$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).collect((PartialFunction)new scala.Serializable(requiredValueMap){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map requiredValueMap$1;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = this.requiredValueMap$1.getOrElse(A1, (Function0 & Serializable & scala.Serializable)() -> null);
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x2) {
                    String string = x2;
                    boolean bl = true;
                    return bl;
                }
                {
                    this.requiredValueMap$1 = requiredValueMap$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        } else if (!bl) {
            tuple2Array = values;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Tuple2[] requiredValues = tuple2Array;
        return new GenericRowWithSchema((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredValues)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())), DataTypes.createStructType((StructField[])((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredValues)).map((Function1 & Serializable & scala.Serializable)x$2 -> (StructField)x$2._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))));
    }

    public String[] documentToRow$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public BsonDocument rowToDocument(Row row) {
        return (BsonDocument)this.rowToDocumentMapper(row.schema(), true).apply((Object)row);
    }

    public Function1<Row, BsonDocument> rowToDocumentMapper(StructType schema, boolean extendedBsonTypes) {
        Function2[] mappers = (Function2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Function2 & Serializable & scala.Serializable intersect;
            DataType dataType = field.dataType();
            NullType$ nullType$ = NullType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(nullType$) : nullType$ != null)) {
                intersect = (Function2 & Serializable & scala.Serializable)(data, document) -> document.append(field.name(), (BsonValue)new BsonNull());
            } else {
                Function1<Object, BsonValue> mapper = MODULE$.wrappedDataTypeToBsonValueMapper(field.dataType(), field.nullable(), extendedBsonTypes);
                intersect = (Function2 & Serializable & scala.Serializable)(data, document) -> data != null ? document.append(field.name(), (BsonValue)mapper.apply(data)) : BoxedUnit.UNIT;
            }
            return intersect;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function2.class)));
        return (Function1 & Serializable & scala.Serializable)row -> {
            void var2_2;
            BsonDocument document = new BsonDocument();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mappers)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Function2 mapper = (Function2)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Object value = row.isNullAt(i) ? null : row.get(i);
                Object object = mapper.apply(value, (Object)document);
                return object;
            });
            return var2_2;
        };
    }

    private Function1<Object, BsonValue> wrappedDataTypeToBsonValueMapper(DataType elementType, boolean nullable, boolean extendedBsonTypes) {
        return (Function1 & Serializable & scala.Serializable)element -> {
            BsonValue bsonValue;
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (BsonValue)MODULE$.dataTypeToBsonValueMapper(elementType, nullable, extendedBsonTypes).apply(element));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (ex instanceof MongoTypeConversionException) {
                        MongoTypeConversionException mongoTypeConversionException = (MongoTypeConversionException)((Object)((Object)ex));
                        throw mongoTypeConversionException;
                    }
                }
                if (bl) {
                    throw new MongoTypeConversionException(new StringBuilder(20).append("Cannot cast ").append(element).append(" into a ").append(elementType).toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            BsonValue bsonValue2 = bsonValue = (BsonValue)success.value();
            return bsonValue2;
        };
    }

    private Function1<Object, BsonValue> dataTypeToBsonValueMapper(DataType elementType, boolean nullable, boolean extendedBsonTypes) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType = elementType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonBinary((byte[])element);
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonBoolean(BoxesRunTime.unboxToBoolean((Object)element));
        } else if (DateType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonDateTime(((Date)element).getTime());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonDouble(((Number)element).doubleValue());
        } else if (FloatType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonDouble((double)((Number)element).floatValue());
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonInt32(((Number)element).intValue());
        } else if (ShortType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonInt32(((Number)element).intValue());
        } else if (ByteType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonInt32(((Number)element).intValue());
        } else if (LongType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonInt64(((Number)element).longValue());
        } else if (StringType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonString((String)element);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonDateTime(((Timestamp)element).getTime());
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType(), arrayType.containsNull(), extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)element -> (BsonValue)mapper.apply((Object)((Seq)element));
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType, extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)element -> (BsonValue)mapper.apply((Object)((Row)element));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            Function1 & Serializable & scala.Serializable intersect2 = StringType$.MODULE$.equals(dataType2) ? (Function1 & Serializable & scala.Serializable)element -> (BsonValue)MODULE$.mapTypeToBsonValueMapper(mapType.valueType(), mapType.valueContainsNull(), extendedBsonTypes).apply((Object)((scala.collection.immutable.Map)element)) : (Function1 & Serializable & scala.Serializable)element -> {
                throw new MongoTypeConversionException(new StringBuilder(103).append("Cannot cast ").append(element).append(" into a BsonValue. MapTypes must have keys of StringType for conversion into a BsonDocument").toString());
            };
            intersect = intersect2;
        } else if (elementType.typeName().startsWith("decimal")) {
            Function1 & Serializable & scala.Serializable jBigDecimal = (Function1 & Serializable & scala.Serializable)element -> {
                BigDecimal bigDecimal;
                Object object = element;
                BigDecimal bigDecimal2 = object instanceof BigDecimal ? (bigDecimal = (BigDecimal)object) : ((scala.math.BigDecimal)element).bigDecimal();
                return bigDecimal2;
            };
            intersect = (Function1 & Serializable & scala.Serializable)element -> new BsonDecimal128(new Decimal128((BigDecimal)jBigDecimal.apply(element)));
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)element -> {
                throw new MongoTypeConversionException(new StringBuilder(58).append("Cannot cast ").append(element).append(" into a BsonValue. ").append(elementType).append(" has no matching BsonValue.").toString());
            };
        }
        Function1 & Serializable & scala.Serializable mapper = intersect;
        return nullable ? (Function1 & Serializable & scala.Serializable)element -> element == null ? new BsonNull() : (BsonValue)mapper.apply(element) : mapper;
    }

    private Function1<scala.collection.immutable.Map<String, Object>, BsonValue> mapTypeToBsonValueMapper(DataType valueType, boolean valueContainsNull, boolean extendedBsonTypes) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType = valueType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType, extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (Iterable)data.map((Function1 & Serializable & scala.Serializable)kv -> {
                BsonNull value = valueContainsNull && kv._2() == null ? new BsonNull() : (BsonValue)mapper.apply((Object)((Row)kv._2()));
                return new BsonElement((String)kv._1(), (BsonValue)value);
            }, Iterable$.MODULE$.canBuildFrom());
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType(), arrayType.containsNull(), extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (Iterable)data.map((Function1 & Serializable & scala.Serializable)kv -> {
                BsonNull value = valueContainsNull && kv._2() == null ? new BsonNull() : (BsonValue)mapper.apply((Object)((Seq)kv._2()));
                return new BsonElement((String)kv._1(), (BsonValue)value);
            }, Iterable$.MODULE$.canBuildFrom());
        } else {
            Function1<Object, BsonValue> mapper = this.wrappedDataTypeToBsonValueMapper(valueType, valueContainsNull, extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (Iterable)data.map((Function1 & Serializable & scala.Serializable)kv -> new BsonElement((String)kv._1(), (BsonValue)mapper.apply(kv._2())), Iterable$.MODULE$.canBuildFrom());
        }
        Function1 & Serializable & scala.Serializable internalDataMapper = intersect;
        return (Function1 & Serializable & scala.Serializable)data -> new BsonDocument((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)internalDataMapper.apply(data)).toList()).asJava());
    }

    private Function1<Seq<Object>, BsonValue> arrayTypeToBsonValueMapper(DataType elementType, boolean containsNull, boolean extendedBsonTypes) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1<Row, BsonValue> mapper = this.structTypeToBsonValueMapper(structType, extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1 & Serializable & scala.Serializable)x -> containsNull && x == null ? new BsonNull() : (BsonValue)mapper.apply((Object)((Row)x)), Seq$.MODULE$.canBuildFrom())).asJava();
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Function1<Seq<Object>, BsonValue> mapper = this.arrayTypeToBsonValueMapper(arrayType.elementType(), arrayType.containsNull(), extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1 & Serializable & scala.Serializable)x -> containsNull && x == null ? new BsonNull() : (BsonValue)mapper.apply((Object)((Seq)x)), Seq$.MODULE$.canBuildFrom())).asJava();
        } else {
            Function1<Object, BsonValue> mapper = this.wrappedDataTypeToBsonValueMapper(elementType, containsNull, extendedBsonTypes);
            intersect = (Function1 & Serializable & scala.Serializable)data -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)data.map((Function1 & Serializable & scala.Serializable)x -> containsNull && x == null ? new BsonNull() : (BsonValue)mapper.apply(x), Seq$.MODULE$.canBuildFrom())).asJava();
        }
        Function1 & Serializable & scala.Serializable bsonArrayValuesMapper = intersect;
        return (Function1 & Serializable & scala.Serializable)data -> new BsonArray((List)bsonArrayValuesMapper.apply(data));
    }

    private Function1<Row, BsonValue> structTypeToBsonValueMapper(StructType dataType, boolean extendedBsonTypes) {
        Function1<Row, BsonDocument> function1;
        if (extendedBsonTypes) {
            StructType structType = dataType;
            Function1<Row, BsonDocument> function12 = BsonCompatibility$ObjectId$.MODULE$.unapply(structType) ? row -> (BsonObjectId)BsonCompatibility$ObjectId$.MODULE$.apply((Row)row) : (BsonCompatibility$MinKey$.MODULE$.unapply(structType) ? row -> (BsonMinKey)BsonCompatibility$MinKey$.MODULE$.apply((Row)row) : (BsonCompatibility$MaxKey$.MODULE$.unapply(structType) ? row -> (BsonMaxKey)BsonCompatibility$MaxKey$.MODULE$.apply((Row)row) : (BsonCompatibility$Timestamp$.MODULE$.unapply(structType) ? row -> (BsonTimestamp)BsonCompatibility$Timestamp$.MODULE$.apply((Row)row) : (BsonCompatibility$JavaScript$.MODULE$.unapply(structType) ? row -> (BsonJavaScript)BsonCompatibility$JavaScript$.MODULE$.apply((Row)row) : (BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType) ? row -> (BsonJavaScriptWithScope)BsonCompatibility$JavaScriptWithScope$.MODULE$.apply((Row)row) : (BsonCompatibility$RegularExpression$.MODULE$.unapply(structType) ? row -> (BsonRegularExpression)BsonCompatibility$RegularExpression$.MODULE$.apply((Row)row) : (BsonCompatibility$Undefined$.MODULE$.unapply(structType) ? row -> (BsonUndefined)BsonCompatibility$Undefined$.MODULE$.apply((Row)row) : (BsonCompatibility$Binary$.MODULE$.unapply(structType) ? row -> (BsonBinary)BsonCompatibility$Binary$.MODULE$.apply((Row)row) : (BsonCompatibility$Symbol$.MODULE$.unapply(structType) ? row -> (BsonSymbol)BsonCompatibility$Symbol$.MODULE$.apply((Row)row) : (BsonCompatibility$DbPointer$.MODULE$.unapply(structType) ? row -> (BsonDbPointer)BsonCompatibility$DbPointer$.MODULE$.apply((Row)row) : this.rowToDocumentMapper(dataType, extendedBsonTypes)))))))))));
            function1 = function12;
        } else {
            function1 = this.rowToDocumentMapper(dataType, extendedBsonTypes);
        }
        return function1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Object convertToDataType(BsonValue element, DataType elementType) {
        DataType dataType;
        BsonType bsonType;
        void var3_24;
        Tuple2 tuple2 = new Tuple2((Object)element.getBsonType(), (Object)elementType);
        if (tuple2 != null) {
            BsonType bsonType2 = (BsonType)tuple2._1();
            DataType mapType = (DataType)tuple2._2();
            if (BsonType.DOCUMENT.equals(bsonType2) && mapType instanceof MapType) {
                MapType mapType2 = (MapType)mapType;
                scala.collection.immutable.Map map = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)element.asDocument()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), MODULE$.convertToDataType((BsonValue)kv._2(), mapType2.valueType())), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType3 = (BsonType)tuple2._1();
            DataType arrayType = (DataType)tuple2._2();
            if (BsonType.ARRAY.equals(bsonType3) && arrayType instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)arrayType;
                Object object = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(element.asArray().getValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convertToDataType((BsonValue)x$3, arrayType2.elementType()), Buffer$.MODULE$.canBuildFrom());
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType4 = (BsonType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (BsonType.BINARY.equals(bsonType4) && BinaryType$.MODULE$.equals(dataType2)) {
                byte[] byArray = element.asBinary().getData();
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType5 = (BsonType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (BsonType.BOOLEAN.equals(bsonType5) && BooleanType$.MODULE$.equals(dataType3)) {
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)element.asBoolean().getValue());
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType6 = (BsonType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (BsonType.DATE_TIME.equals(bsonType6) && DateType$.MODULE$.equals(dataType4)) {
                Date date = new Date(element.asDateTime().getValue());
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType7 = (BsonType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (BsonType.DATE_TIME.equals(bsonType7) && TimestampType$.MODULE$.equals(dataType5)) {
                Timestamp timestamp = new Timestamp(element.asDateTime().getValue());
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType8 = (BsonType)tuple2._1();
            DataType dataType6 = (DataType)tuple2._2();
            if (BsonType.NULL.equals(bsonType8) && NullType$.MODULE$.equals(dataType6)) {
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType9 = (BsonType)tuple2._1();
            DataType dataType7 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType9) && DoubleType$.MODULE$.equals(dataType7)) {
                Double d = BoxesRunTime.boxToDouble((double)this.toDouble(element));
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType10 = (BsonType)tuple2._1();
            DataType dataType8 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType10) && FloatType$.MODULE$.equals(dataType8)) {
                Double d = BoxesRunTime.boxToDouble((double)this.toFloat(element));
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType11 = (BsonType)tuple2._1();
            DataType dataType9 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType11) && IntegerType$.MODULE$.equals(dataType9)) {
                Integer n = BoxesRunTime.boxToInteger((int)this.toInt(element));
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType12 = (BsonType)tuple2._1();
            DataType dataType10 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType12) && ShortType$.MODULE$.equals(dataType10)) {
                Short s = BoxesRunTime.boxToShort((short)this.toShort(element));
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType13 = (BsonType)tuple2._1();
            DataType dataType11 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType13) && ByteType$.MODULE$.equals(dataType11)) {
                Byte by = BoxesRunTime.boxToByte((byte)this.toByte(element));
                return var3_24;
            }
        }
        if (tuple2 != null) {
            BsonType bsonType14 = (BsonType)tuple2._1();
            DataType dataType12 = (DataType)tuple2._2();
            if (MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType14) && LongType$.MODULE$.equals(dataType12)) {
                Long l = BoxesRunTime.boxToLong((long)this.toLong(element));
                return var3_24;
            }
        }
        if (tuple2 != null && MapFunctions$isBsonNumber$.MODULE$.unapply(bsonType = (BsonType)tuple2._1()) && elementType.typeName().startsWith("decimal")) {
            scala.math.BigDecimal bigDecimal = this.toDecimal(element);
            return var3_24;
        }
        if (tuple2 != null) {
            BsonType bsonType15 = (BsonType)tuple2._1();
            DataType schema = (DataType)tuple2._2();
            if (MapFunctions$notNull$.MODULE$.unapply(bsonType15) && schema instanceof StructType) {
                StructType structType = (StructType)schema;
                Object object = this.castToStructType(element, structType);
                return var3_24;
            }
        }
        if (tuple2 != null && StringType$.MODULE$.equals(dataType = (DataType)tuple2._2())) {
            String string = this.bsonValueToString(element);
            return var3_24;
        }
        if (!element.isNull()) throw new MongoTypeConversionException(new StringBuilder(30).append("Cannot cast ").append(element.getBsonType()).append(" into a ").append(elementType).append(" (value: ").append(element).append(")").toString());
        return var3_24;
    }

    private String bsonValueToString(BsonValue element) {
        BsonType bsonType = element.getBsonType();
        Object object = BsonType.STRING.equals(bsonType) ? element.asString().getValue() : (BsonType.OBJECT_ID.equals(bsonType) ? element.asObjectId().getValue().toHexString() : (BsonType.INT64.equals(bsonType) ? ((Object)BoxesRunTime.boxToLong((long)element.asInt64().getValue())).toString() : (BsonType.INT32.equals(bsonType) ? ((Object)BoxesRunTime.boxToInteger((int)element.asInt32().getValue())).toString() : (BsonType.DOUBLE.equals(bsonType) ? ((Object)BoxesRunTime.boxToDouble((double)element.asDouble().getValue())).toString() : (BsonType.NULL.equals(bsonType) ? null : BsonValueToJson$.MODULE$.apply(element))))));
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object castToStructType(BsonValue element, StructType elementType) {
        BsonType bsonType;
        Tuple2 tuple2 = new Tuple2((Object)element.getBsonType(), (Object)elementType);
        if (tuple2 != null) {
            BsonType bsonType2 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.BINARY.equals(bsonType2) && BsonCompatibility$Binary$.MODULE$.unapply(structType)) {
                return BsonCompatibility$Binary$.MODULE$.apply((BsonValue)((BsonBinary)element), elementType);
            }
        }
        if (tuple2 != null && BsonType.DOCUMENT.equals(bsonType = (BsonType)tuple2._1())) {
            return this.documentToRow((BsonDocument)element, elementType, this.documentToRow$default$3());
        }
        if (tuple2 != null) {
            BsonType bsonType3 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.DB_POINTER.equals(bsonType3) && BsonCompatibility$DbPointer$.MODULE$.unapply(structType)) {
                return BsonCompatibility$DbPointer$.MODULE$.apply((BsonValue)((BsonDbPointer)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType4 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.JAVASCRIPT.equals(bsonType4) && BsonCompatibility$JavaScript$.MODULE$.unapply(structType)) {
                return BsonCompatibility$JavaScript$.MODULE$.apply((BsonValue)((BsonJavaScript)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType5 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.JAVASCRIPT_WITH_SCOPE.equals(bsonType5) && BsonCompatibility$JavaScriptWithScope$.MODULE$.unapply(structType)) {
                return BsonCompatibility$JavaScriptWithScope$.MODULE$.apply((BsonValue)((BsonJavaScriptWithScope)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType6 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.MIN_KEY.equals(bsonType6) && BsonCompatibility$MinKey$.MODULE$.unapply(structType)) {
                return BsonCompatibility$MinKey$.MODULE$.apply((BsonValue)((BsonMinKey)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType7 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.MAX_KEY.equals(bsonType7) && BsonCompatibility$MaxKey$.MODULE$.unapply(structType)) {
                return BsonCompatibility$MaxKey$.MODULE$.apply((BsonValue)((BsonMaxKey)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType8 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.OBJECT_ID.equals(bsonType8) && BsonCompatibility$ObjectId$.MODULE$.unapply(structType)) {
                return BsonCompatibility$ObjectId$.MODULE$.apply((BsonValue)((BsonObjectId)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType9 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.REGULAR_EXPRESSION.equals(bsonType9) && BsonCompatibility$RegularExpression$.MODULE$.unapply(structType)) {
                return BsonCompatibility$RegularExpression$.MODULE$.apply((BsonValue)((BsonRegularExpression)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType10 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.SYMBOL.equals(bsonType10) && BsonCompatibility$Symbol$.MODULE$.unapply(structType)) {
                return BsonCompatibility$Symbol$.MODULE$.apply((BsonValue)((BsonSymbol)element), elementType);
            }
        }
        if (tuple2 != null) {
            BsonType bsonType11 = (BsonType)tuple2._1();
            StructType structType = (StructType)tuple2._2();
            if (BsonType.TIMESTAMP.equals(bsonType11) && BsonCompatibility$Timestamp$.MODULE$.unapply(structType)) {
                return BsonCompatibility$Timestamp$.MODULE$.apply((BsonValue)((BsonTimestamp)element), elementType);
            }
        }
        if (tuple2 == null) throw new MongoTypeConversionException(new StringBuilder(30).append("Cannot cast ").append(element.getBsonType()).append(" into a ").append(elementType).append(" (value: ").append(element).append(")").toString());
        BsonType bsonType12 = (BsonType)tuple2._1();
        StructType structType = (StructType)tuple2._2();
        if (!BsonType.UNDEFINED.equals(bsonType12)) throw new MongoTypeConversionException(new StringBuilder(30).append("Cannot cast ").append(element.getBsonType()).append(" into a ").append(elementType).append(" (value: ").append(element).append(")").toString());
        if (!BsonCompatibility$Undefined$.MODULE$.unapply(structType)) throw new MongoTypeConversionException(new StringBuilder(30).append("Cannot cast ").append(element.getBsonType()).append(" into a ").append(elementType).append(" (value: ").append(element).append(")").toString());
        return BsonCompatibility$Undefined$.MODULE$.apply((BsonValue)((BsonUndefined)element), elementType);
    }

    private int toInt(BsonValue bsonValue) {
        int n;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.DECIMAL128.equals(bsonType)) {
            n = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().intValue();
        } else if (BsonType.INT32.equals(bsonType)) {
            n = bsonValue.asInt32().intValue();
        } else if (BsonType.INT64.equals(bsonType)) {
            n = bsonValue.asInt64().intValue();
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            n = bsonValue.asDouble().intValue();
        } else {
            throw new MongoTypeConversionException(new StringBuilder(23).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Int").toString());
        }
        return n;
    }

    private short toShort(BsonValue bsonValue) {
        short v;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> (short)MODULE$.toInt(bsonValue));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new MongoTypeConversionException(new StringBuilder(25).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Short").toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        short s = v = BoxesRunTime.unboxToShort((Object)success.value());
        return s;
    }

    private byte toByte(BsonValue bsonValue) {
        byte v;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)MODULE$.toInt(bsonValue));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new MongoTypeConversionException(new StringBuilder(24).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Byte").toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte by = v = BoxesRunTime.unboxToByte((Object)success.value());
        return by;
    }

    private long toLong(BsonValue bsonValue) {
        long l;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.DECIMAL128.equals(bsonType)) {
            l = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().longValue();
        } else if (BsonType.INT32.equals(bsonType)) {
            l = bsonValue.asInt32().longValue();
        } else if (BsonType.INT64.equals(bsonType)) {
            l = bsonValue.asInt64().longValue();
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            l = bsonValue.asDouble().longValue();
        } else {
            throw new MongoTypeConversionException(new StringBuilder(24).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Long").toString());
        }
        return l;
    }

    private double toDouble(BsonValue bsonValue) {
        double d;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.DECIMAL128.equals(bsonType)) {
            d = bsonValue.asDecimal128().decimal128Value().bigDecimalValue().doubleValue();
        } else if (BsonType.INT32.equals(bsonType)) {
            d = bsonValue.asInt32().doubleValue();
        } else if (BsonType.INT64.equals(bsonType)) {
            d = bsonValue.asInt64().doubleValue();
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            d = bsonValue.asDouble().doubleValue();
        } else {
            throw new MongoTypeConversionException(new StringBuilder(26).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Double").toString());
        }
        return d;
    }

    private double toFloat(BsonValue bsonValue) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (float)MODULE$.toDouble(bsonValue));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new MongoTypeConversionException(new StringBuilder(25).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a Float").toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        float v = BoxesRunTime.unboxToFloat((Object)success.value());
        double d = v;
        return d;
    }

    private scala.math.BigDecimal toDecimal(BsonValue bsonValue) {
        scala.math.BigDecimal bigDecimal;
        BsonType bsonType = bsonValue.getBsonType();
        if (BsonType.DECIMAL128.equals(bsonType)) {
            bigDecimal = BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bsonValue.asDecimal128().decimal128Value().bigDecimalValue());
        } else if (BsonType.INT32.equals(bsonType)) {
            bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt32().intValue());
        } else if (BsonType.INT64.equals(bsonType)) {
            bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asInt64().longValue());
        } else if (BsonType.DOUBLE.equals(bsonType)) {
            bigDecimal = package$.MODULE$.BigDecimal().apply(bsonValue.asDouble().doubleValue());
        } else {
            throw new MongoTypeConversionException(new StringBuilder(30).append("Cannot cast ").append(bsonValue.getBsonType()).append(" into a BigDecimal").toString());
        }
        return bigDecimal;
    }

    private MapFunctions$() {
        MODULE$ = this;
    }
}

