/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.exceptions.MongoPartitionerException;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import com.mongodb.spark.rdd.partitioner.MongoPartitioner;
import com.mongodb.spark.rdd.partitioner.MongoSinglePartitioner$;
import com.mongodb.spark.rdd.partitioner.MongoSplitVectorPartitioner$;
import com.mongodb.spark.rdd.partitioner.PartitionerHelper$;
import java.io.Serializable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\f\u0019\u0001\rBQ\u0001\f\u0001\u0005\u00025Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u00031\u0011\u0019Y\u0004\u0001)A\u0005c!9A\b\u0001b\u0001\n\u0003\u0001\u0004BB\u001f\u0001A\u0003%\u0011\u0007C\u0004?\u0001\t\u0007I\u0011\u0001\u0019\t\r}\u0002\u0001\u0015!\u00032\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0011\u0015\u0019\u0007\u0001\"\u0003e\u000f\u001d\ti\u0001\u0007EA\u0003\u001f1aa\u0006\r\t\u0002\u0006E\u0001B\u0002\u0017\u000e\t\u0003\ty\u0002\u0003\u0005\u0002\"5\t\t\u0011\"\u00111\u0011%\t\u0019#DA\u0001\n\u0003\t)\u0003C\u0005\u0002.5\t\t\u0011\"\u0001\u00020!I\u00111H\u0007\u0002\u0002\u0013\u0005\u0013Q\b\u0005\n\u0003\u0017j\u0011\u0011!C\u0001\u0003\u001bB\u0011\"a\u0016\u000e\u0003\u0003%\t%!\u0017\t\u0013\u0005mS\"!A\u0005B\u0005u\u0003\"CA0\u001b\u0005\u0005I\u0011BA1\u0005miuN\\4p'Bd\u0017\u000e\u001e,fGR|'\u000fU1si&$\u0018n\u001c8fe*\u0011\u0011DG\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u001c9\u0005\u0019!\u000f\u001a3\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u001diwN\\4pI\nT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011B\u0003CA\u0013'\u001b\u0005a\u0012BA\u0014\u001d\u0005\u001daunZ4j]\u001e\u0004\"!\u000b\u0016\u000e\u0003aI!a\u000b\r\u0003!5{gnZ8QCJ$\u0018\u000e^5p]\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001/!\tI\u0003!A\nEK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p].+\u00170F\u00012!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u0015;sS:<\u0017\u0001\u0006#fM\u0006,H\u000e\u001e)beRLG/[8o\u0017\u0016L\b%\u0001\fEK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]NK'0Z'C\u0003]!UMZ1vYR\u0004\u0016M\u001d;ji&|gnU5{K6\u0013\u0005%\u0001\u000bqCJ$\u0018\u000e^5p].+\u0017\u0010\u0015:pa\u0016\u0014H/_\u0001\u0016a\u0006\u0014H/\u001b;j_:\\U-\u001f)s_B,'\u000f^=!\u0003]\u0001\u0018M\u001d;ji&|gnU5{K6\u0013\u0005K]8qKJ$\u00180\u0001\rqCJ$\u0018\u000e^5p]NK'0Z'C!J|\u0007/\u001a:us\u0002\n!\u0002]1si&$\u0018n\u001c8t)\u0011\u00115\n\u0015-\u0011\u0007\r3\u0005*D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0015\t%O]1z!\tI\u0013*\u0003\u0002K1\tqQj\u001c8h_B\u000b'\u000f^5uS>t\u0007\"\u0002'\u000b\u0001\u0004i\u0015!C2p]:,7\r^8s!\t)c*\u0003\u0002P9\tqQj\u001c8h_\u000e{gN\\3di>\u0014\b\"B)\u000b\u0001\u0004\u0011\u0016A\u0003:fC\u0012\u001cuN\u001c4jOB\u00111KV\u0007\u0002)*\u0011Q\u000bH\u0001\u0007G>tg-[4\n\u0005]#&A\u0003*fC\u0012\u001cuN\u001c4jO\")\u0011L\u0003a\u00015\u0006A\u0001/\u001b9fY&tW\rE\u0002D\rn\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\t\t\u001cxN\u001c\u0006\u0002A\u0006\u0019qN]4\n\u0005\tl&\u0001\u0004\"t_:$unY;nK:$\u0018\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)\u0015\u0011U-]:\u007f\u0011\u001517\u00021\u0001h\u00031\u0001\u0018M\u001d;ji&|gnS3z!\tAwN\u0004\u0002j[B\u0011!\u000eR\u0007\u0002W*\u0011ANI\u0001\u0007yI|w\u000e\u001e \n\u00059$\u0015A\u0002)sK\u0012,g-\u0003\u00029a*\u0011a\u000e\u0012\u0005\u0006e.\u0001\raW\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000bQ\\\u0001\u0019A;\u0002\u00131|7-\u0019;j_:\u001c\bc\u0001<|O:\u0011q/\u001f\b\u0003UbL\u0011!R\u0005\u0003u\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005i$\u0005BB@\f\u0001\u0004\t\t!A\u0005nS:l\u0015\r_&fsB91)a\u0001\u0002\b\u0005\u001d\u0011bAA\u0003\t\n1A+\u001e9mKJ\u00022\u0001XA\u0005\u0013\r\tY!\u0018\u0002\n\u0005N|gNV1mk\u0016\f1$T8oO>\u001c\u0006\u000f\\5u-\u0016\u001cGo\u001c:QCJ$\u0018\u000e^5p]\u0016\u0014\bCA\u0015\u000e'\u0019ia&a\u0005\u0002\u001aA\u00191)!\u0006\n\u0007\u0005]AIA\u0004Qe>$Wo\u0019;\u0011\u0007\r\u000bY\"C\u0002\u0002\u001e\u0011\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0003E\u0002D\u0003SI1!a\u000bE\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t$a\u000e\u0011\u0007\r\u000b\u0019$C\u0002\u00026\u0011\u00131!\u00118z\u0011%\tI$EA\u0001\u0002\u0004\t9#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0001b!!\u0011\u0002H\u0005ERBAA\"\u0015\r\t)\u0005R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qJA+!\r\u0019\u0015\u0011K\u0005\u0004\u0003'\"%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003s\u0019\u0012\u0011!a\u0001\u0003c\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002c\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u0007E\u00023\u0003KJ1!a\u001a4\u0005\u0019y%M[3di\u0002")
public class MongoSplitVectorPartitioner
extends Logging
implements MongoPartitioner {
    private final String DefaultPartitionKey;
    private final String DefaultPartitionSizeMB;
    private final String partitionKeyProperty = "partitionKey".toLowerCase();
    private final String partitionSizeMBProperty = "partitionSizeMB".toLowerCase();

    public static boolean canEqual(Object object) {
        return MongoSplitVectorPartitioner$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return MongoSplitVectorPartitioner$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return MongoSplitVectorPartitioner$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return MongoSplitVectorPartitioner$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return MongoSplitVectorPartitioner$.MODULE$.productPrefix();
    }

    private String DefaultPartitionKey() {
        return this.DefaultPartitionKey;
    }

    private String DefaultPartitionSizeMB() {
        return this.DefaultPartitionSizeMB;
    }

    public String partitionKeyProperty() {
        return this.partitionKeyProperty;
    }

    public String partitionSizeMBProperty() {
        return this.partitionSizeMBProperty;
    }

    @Override
    public MongoPartition[] partitions(MongoConnector connector, ReadConfig readConfig, BsonDocument[] pipeline) {
        String ns = new StringBuilder(1).append(readConfig.databaseName()).append(".").append(readConfig.collectionName()).toString();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Getting split bounds for a non-sharded collection: ").append(ns).toString());
        Map partitionerOptions = (Map)readConfig.partitionerOptions().map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((String)kv._1()).toLowerCase(), kv._2()), Map$.MODULE$.canBuildFrom());
        String partitionKey = (String)partitionerOptions.getOrElse((Object)this.partitionKeyProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultPartitionKey());
        int partitionSize = new StringOps(Predef$.MODULE$.augmentString((String)partitionerOptions.getOrElse((Object)this.partitionSizeMBProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultPartitionSizeMB()))).toInt();
        BsonDocument keyPattern = new BsonDocument(partitionKey, (BsonValue)new BsonInt32(1));
        Tuple2<BsonValue, BsonValue> minKeyMaxKey = PartitionerHelper$.MODULE$.getSplitVectorRangeQuery(partitionKey, pipeline);
        BsonDocument splitVectorCommand = new BsonDocument("splitVector", (BsonValue)new BsonString(ns)).append("keyPattern", (BsonValue)keyPattern).append("maxChunkSize", (BsonValue)new BsonInt32(partitionSize)).append("min", (BsonValue)new BsonDocument(partitionKey, (BsonValue)minKeyMaxKey._1())).append("max", (BsonValue)new BsonDocument(partitionKey, (BsonValue)minKeyMaxKey._2()));
        return (MongoPartition[])connector.withDatabaseDo((MongoCollectionConfig)readConfig, (Function1 & Serializable & scala.Serializable)db -> {
            MongoPartition[] mongoPartitionArray;
            Success success;
            BsonDocument result;
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (BsonDocument)db.runCommand((Bson)splitVectorCommand, BsonDocument.class));
            if (try_ instanceof Success && (result = (BsonDocument)(success = (Success)try_).value()) != null) {
                BsonDocument bsonDocument = result;
                Seq<String> locations = PartitionerHelper$.MODULE$.locations(connector);
                mongoPartitionArray = this.createPartitions(partitionKey, bsonDocument, locations, minKeyMaxKey);
            } else {
                MongoCommandException mongoCommandException;
                Throwable ex;
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (e instanceof MongoNotPrimaryException) {
                        MongoNotPrimaryException mongoNotPrimaryException = (MongoNotPrimaryException)e;
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The `SplitVector` command must be run on the primary node");
                        throw mongoNotPrimaryException;
                    }
                }
                if (bl && (ex = failure.exception()) instanceof MongoCommandException && (mongoCommandException = (MongoCommandException)ex).getErrorMessage().contains("ns not found")) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Could not find collection (").append(readConfig.collectionName()).append("), using a single partition").toString());
                    mongoPartitionArray = MongoSinglePartitioner$.MODULE$.partitions(connector, readConfig, pipeline);
                } else {
                    Throwable t;
                    if (bl && (t = failure.exception()) != null) {
                        Throwable throwable = t;
                        throw throwable;
                    }
                    throw new MatchError((Object)try_);
                }
            }
            return mongoPartitionArray;
        });
    }

    private MongoPartition[] createPartitions(String partitionKey, BsonDocument result, Seq<String> locations, Tuple2<BsonValue, BsonValue> minMaxKey) {
        MongoPartition[] partitions;
        double d = result.getDouble((Object)"ok").getValue();
        if (1.0 == d) {
            BsonValue bsonValue;
            Buffer splitKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)result.get((Object)"splitKeys")).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get((Object)partitionKey), Buffer$.MODULE$.canBuildFrom());
            Buffer rightHandBoundaries = (Buffer)((SeqLike)splitKeys.$plus$colon((Object)(bsonValue = (BsonValue)minMaxKey._1()), Buffer$.MODULE$.canBuildFrom())).$colon$plus(minMaxKey._2(), Buffer$.MODULE$.canBuildFrom());
            partitions = PartitionerHelper$.MODULE$.createPartitions(partitionKey, (Seq<BsonValue>)rightHandBoundaries, locations, false);
            if (partitions.length == 1) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No splitKeys were calculated by the splitVector command, proceeding with a single partition.\n              |If this is undesirable try lowering 'partitionSizeMB' property to produce more partitions.")).stripMargin().replaceAll("\n", " "));
            }
        } else {
            throw new MongoPartitionerException(new StringBuilder(54).append("Could not calculate standalone splits. Server errmsg: ").append(result.get((Object)"errmsg")).toString());
        }
        MongoPartition[] mongoPartitionArray = partitions;
        return mongoPartitionArray;
    }

    public MongoSplitVectorPartitioner() {
        this.DefaultPartitionKey = "_id";
        this.DefaultPartitionSizeMB = "64";
    }
}

