/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.MongoCommandException;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import com.mongodb.spark.rdd.partitioner.MongoPartitioner;
import com.mongodb.spark.rdd.partitioner.MongoSamplePartitioner$;
import com.mongodb.spark.rdd.partitioner.MongoSinglePartitioner$;
import com.mongodb.spark.rdd.partitioner.PartitionerHelper$;
import java.io.Serializable;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\u000e\u001c\u0001\u0019BQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00034\u0011\u0019q\u0004\u0001)A\u0005i!9q\b\u0001b\u0001\n\u0013\u0019\u0004B\u0002!\u0001A\u0003%A\u0007C\u0004B\u0001\t\u0007I\u0011A\u001a\t\r\t\u0003\u0001\u0015!\u00035\u0011\u001d\u0019\u0005A1A\u0005\u0002MBa\u0001\u0012\u0001!\u0002\u0013!\u0004bB#\u0001\u0005\u0004%\ta\r\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001b\t\u000b\u001d\u0003A\u0011\t%\b\u000b)\\\u0002\u0012Q6\u0007\u000biY\u0002\u0012\u00117\t\u000b=\u0002B\u0011A:\t\u000fQ\u0004\u0012\u0011!C!g!9Q\u000fEA\u0001\n\u00031\bb\u0002>\u0011\u0003\u0003%\ta\u001f\u0005\n\u0003\u0007\u0001\u0012\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0011\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001#!A\u0005B\u0005\u0005\u0002\"CA\u0012!\u0005\u0005I\u0011IA\u0013\u0011%\t9\u0003EA\u0001\n\u0013\tIC\u0001\fN_:<wnU1na2,\u0007+\u0019:uSRLwN\\3s\u0015\taR$A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(B\u0001\u0010 \u0003\r\u0011H\r\u001a\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\u000f5|gnZ8eE*\tA%A\u0002d_6\u001c\u0001aE\u0002\u0001O-\u0002\"\u0001K\u0015\u000e\u0003}I!AK\u0010\u0003\u000f1{wmZ5oOB\u0011A&L\u0007\u00027%\u0011af\u0007\u0002\u0011\u001b>twm\u001c)beRLG/[8oKJ\fa\u0001P5oSRtD#A\u0019\u0011\u00051\u0002\u0011a\u0005#fM\u0006,H\u000e\u001e)beRLG/[8o\u0017\u0016LX#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00027b]\u001eT\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\t11\u000b\u001e:j]\u001e\fA\u0003R3gCVdG\u000fU1si&$\u0018n\u001c8LKf\u0004\u0013A\u0006#fM\u0006,H\u000e\u001e)beRLG/[8o'&TX-\u0014\"\u0002/\u0011+g-Y;miB\u000b'\u000f^5uS>t7+\u001b>f\u001b\n\u0003\u0013A\u0007#fM\u0006,H\u000e^*b[BdWm\u001d)feB\u000b'\u000f^5uS>t\u0017a\u0007#fM\u0006,H\u000e^*b[BdWm\u001d)feB\u000b'\u000f^5uS>t\u0007%\u0001\u000bqCJ$\u0018\u000e^5p].+\u0017\u0010\u0015:pa\u0016\u0014H/_\u0001\u0016a\u0006\u0014H/\u001b;j_:\\U-\u001f)s_B,'\u000f^=!\u0003]\u0001\u0018M\u001d;ji&|gnU5{K6\u0013\u0005K]8qKJ$\u00180\u0001\rqCJ$\u0018\u000e^5p]NK'0Z'C!J|\u0007/\u001a:us\u0002\n1d]1na2,7\u000fU3s!\u0006\u0014H/\u001b;j_:\u0004&o\u001c9feRL\u0018\u0001H:b[BdWm\u001d)feB\u000b'\u000f^5uS>t\u0007K]8qKJ$\u0018\u0010I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cH\u0003B%S/~\u00032AS'P\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%!B!se\u0006L\bC\u0001\u0017Q\u0013\t\t6D\u0001\bN_:<w\u000eU1si&$\u0018n\u001c8\t\u000bMs\u0001\u0019\u0001+\u0002\u0013\r|gN\\3di>\u0014\bC\u0001\u0015V\u0013\t1vD\u0001\bN_:<wnQ8o]\u0016\u001cGo\u001c:\t\u000bas\u0001\u0019A-\u0002\u0015I,\u0017\rZ\"p]\u001aLw\r\u0005\u0002[;6\t1L\u0003\u0002]?\u000511m\u001c8gS\u001eL!AX.\u0003\u0015I+\u0017\rZ\"p]\u001aLw\rC\u0003a\u001d\u0001\u0007\u0011-\u0001\u0005qSB,G.\u001b8f!\rQUJ\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fAAY:p]*\tq-A\u0002pe\u001eL!!\u001b3\u0003\u0019\t\u001bxN\u001c#pGVlWM\u001c;\u0002-5{gnZ8TC6\u0004H.\u001a)beRLG/[8oKJ\u0004\"\u0001\f\t\u0014\tA\tT\u000e\u001d\t\u0003\u0015:L!a\\&\u0003\u000fA\u0013x\u000eZ;diB\u0011!*]\u0005\u0003e.\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\u0012a[\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003]\u0004\"A\u0013=\n\u0005e\\%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u0001?\u0000!\tQU0\u0003\u0002\u007f\u0017\n\u0019\u0011I\\=\t\u0011\u0005\u0005A#!AA\u0002]\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0004!\u0015\tI!a\u0004}\u001b\t\tYAC\u0002\u0002\u000e-\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t\"a\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003/\ti\u0002E\u0002K\u00033I1!a\u0007L\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0001\u0017\u0003\u0003\u0005\r\u0001`\u0001\tQ\u0006\u001c\bnQ8eKR\tq/\u0001\u0005u_N#(/\u001b8h)\u0005!\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u000b\u0011\u0007U\ni#C\u0002\u00020Y\u0012aa\u00142kK\u000e$\b")
public class MongoSamplePartitioner
extends Logging
implements MongoPartitioner {
    private final String DefaultPartitionKey;
    private final String DefaultPartitionSizeMB;
    private final String DefaultSamplesPerPartition;
    private final String partitionKeyProperty = "partitionKey".toLowerCase();
    private final String partitionSizeMBProperty = "partitionSizeMB".toLowerCase();
    private final String samplesPerPartitionProperty = "samplesPerPartition".toLowerCase();

    public static boolean canEqual(Object object) {
        return MongoSamplePartitioner$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return MongoSamplePartitioner$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return MongoSamplePartitioner$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return MongoSamplePartitioner$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return MongoSamplePartitioner$.MODULE$.productPrefix();
    }

    private String DefaultPartitionKey() {
        return this.DefaultPartitionKey;
    }

    private String DefaultPartitionSizeMB() {
        return this.DefaultPartitionSizeMB;
    }

    private String DefaultSamplesPerPartition() {
        return this.DefaultSamplesPerPartition;
    }

    public String partitionKeyProperty() {
        return this.partitionKeyProperty;
    }

    public String partitionSizeMBProperty() {
        return this.partitionSizeMBProperty;
    }

    public String samplesPerPartitionProperty() {
        return this.samplesPerPartitionProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MongoPartition[] partitions(MongoConnector connector, ReadConfig readConfig, BsonDocument[] pipeline) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> PartitionerHelper$.MODULE$.collStats(connector, readConfig));
        if (try_ instanceof Success) {
            MongoPartition[] mongoPartitionArray;
            Success success = (Success)try_;
            BsonDocument results = (BsonDocument)success.value();
            BsonDocument matchQuery = PartitionerHelper$.MODULE$.matchQuery(pipeline);
            Map partitionerOptions = (Map)readConfig.partitionerOptions().map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((String)kv._1()).toLowerCase(), kv._2()), Map$.MODULE$.canBuildFrom());
            String partitionKey = (String)partitionerOptions.getOrElse((Object)this.partitionKeyProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultPartitionKey());
            int partitionSizeInBytes = new StringOps(Predef$.MODULE$.augmentString((String)partitionerOptions.getOrElse((Object)this.partitionSizeMBProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultPartitionSizeMB()))).toInt() * 1024 * 1024;
            int samplesPerPartition = new StringOps(Predef$.MODULE$.augmentString((String)partitionerOptions.getOrElse((Object)this.samplesPerPartitionProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultSamplesPerPartition()))).toInt();
            long count = matchQuery.isEmpty() ? results.getNumber((Object)"count").longValue() : BoxesRunTime.unboxToLong(connector.withCollectionDo((MongoCollectionConfig)readConfig, (Function1 & Serializable & scala.Serializable)coll -> BoxesRunTime.boxToLong((long)coll.countDocuments((Bson)matchQuery)), ClassTag$.MODULE$.apply(BsonDocument.class)));
            long avgObjSizeInBytes = results.get((Object)"avgObjSize", (BsonValue)new BsonInt64(0L)).asNumber().longValue();
            int numDocumentsPerPartition = (int)package$.MODULE$.floor((double)((float)partitionSizeInBytes / (float)avgObjSizeInBytes));
            int numberOfSamples = (int)package$.MODULE$.floor((double)((float)((double)((long)samplesPerPartition * count) / (double)numDocumentsPerPartition)));
            if ((long)numDocumentsPerPartition >= count) {
                mongoPartitionArray = MongoSinglePartitioner$.MODULE$.partitions(connector, readConfig, pipeline);
                return mongoPartitionArray;
            } else {
                Buffer samples = (Buffer)connector.withCollectionDo((MongoCollectionConfig)readConfig, (Function1 & Serializable & scala.Serializable)coll -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)coll.aggregate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Aggregates.match((Bson)matchQuery), (List)new .colon.colon((Object)Aggregates.sample((int)numberOfSamples), (List)new .colon.colon((Object)Aggregates.project((Bson)Projections.include((String[])new String[]{partitionKey})), (List)new .colon.colon((Object)Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{partitionKey})), (List)Nil$.MODULE$))))).asJava()).allowDiskUse(Predef$.MODULE$.boolean2Boolean(true)).into(new ArrayList())).asScala(), ClassTag$.MODULE$.apply(BsonDocument.class));
                Buffer rightHandBoundaries = (Buffer)((TraversableLike)samples.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(this, partitionKey, samplesPerPartition, matchQuery, count){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoSamplePartitioner $outer;
                    private final String partitionKey$1;
                    private final int samplesPerPartition$1;
                    private final BsonDocument matchQuery$1;
                    private final long count$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<BsonDocument, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            BsonDocument field = (BsonDocument)A1._1();
                            int i = A1._2$mcI$sp();
                            if (MongoSamplePartitioner.com$mongodb$spark$rdd$partitioner$MongoSamplePartitioner$$collectSplit$1(i, this.samplesPerPartition$1, this.matchQuery$1, this.count$1)) {
                                object = field.get((Object)this.partitionKey$1);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<BsonDocument, Object> x1) {
                        int i;
                        Tuple2<BsonDocument, Object> tuple2 = x1;
                        boolean bl = tuple2 != null && MongoSamplePartitioner.com$mongodb$spark$rdd$partitioner$MongoSamplePartitioner$$collectSplit$1(i = tuple2._2$mcI$sp(), this.samplesPerPartition$1, this.matchQuery$1, this.count$1);
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partitionKey$1 = partitionKey$1;
                        this.samplesPerPartition$1 = samplesPerPartition$1;
                        this.matchQuery$1 = matchQuery$1;
                        this.count$1 = count$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                mongoPartitionArray = PartitionerHelper$.MODULE$.createPartitions(partitionKey, (Seq<BsonValue>)rightHandBoundaries, PartitionerHelper$.MODULE$.locations(connector), PartitionerHelper$.MODULE$.createPartitions$default$4());
            }
            return mongoPartitionArray;
        }
        if (try_ instanceof Failure) {
            MongoCommandException mongoCommandException;
            bl = true;
            failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (ex instanceof MongoCommandException && ((mongoCommandException = (MongoCommandException)ex).getErrorMessage().endsWith("not found.") || mongoCommandException.getErrorCode() == 26)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Could not find collection (").append(readConfig.collectionName()).append("), using a single partition").toString());
                return MongoSinglePartitioner$.MODULE$.partitions(connector, readConfig, pipeline);
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Could not get collection statistics. Server errmsg: ").append(e.getMessage()).toString());
        throw e;
    }

    public static final boolean com$mongodb$spark$rdd$partitioner$MongoSamplePartitioner$$collectSplit$1(int i, int samplesPerPartition$1, BsonDocument matchQuery$1, long count$1) {
        return i % samplesPerPartition$1 == 0 || !matchQuery$1.isEmpty() && (long)i == count$1 - 1L;
    }

    public MongoSamplePartitioner() {
        this.DefaultPartitionKey = "_id";
        this.DefaultPartitionSizeMB = "64";
        this.DefaultSamplesPerPartition = "10";
    }
}

