/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.spark.DefaultHelper;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.MongoConnector$;
import com.mongodb.spark.MongoSpark;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import com.mongodb.spark.config.WriteConfig;
import com.mongodb.spark.config.WriteConfig$;
import com.mongodb.spark.package$;
import com.mongodb.spark.rdd.MongoRDD;
import com.mongodb.spark.rdd.api.java.JavaMongoRDD;
import com.mongodb.spark.sql.MapFunctions$;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MongoSpark$
implements scala.Serializable {
    public static MongoSpark$ MODULE$;
    private final String defaultSource;

    static {
        new MongoSpark$();
    }

    public String defaultSource() {
        return this.defaultSource;
    }

    public MongoSpark.Builder builder() {
        return new MongoSpark.Builder();
    }

    public <D> MongoRDD<D> load(SparkContext sc, ClassTag<D> evidence$1, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.load(sc, (ReadConfig)ReadConfig$.MODULE$.apply(sc), evidence$1, e);
    }

    public <D> MongoRDD<D> load(SparkContext sc, ReadConfig readConfig, ClassTag<D> evidence$2, DefaultHelper.DefaultsTo<D, Document> e) {
        return this.builder().sparkContext(sc).readConfig(readConfig).build().toRDD(evidence$2, e);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, TypeTags.TypeTag<D> evidence$3) {
        return this.builder().sparkSession(sparkSession).build().toDF(evidence$3);
    }

    public <D extends Product> Dataset<Row> load(SparkSession sparkSession, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$4) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(evidence$4);
    }

    public <D> void save(RDD<D> rdd, ClassTag<D> evidence$5) {
        this.save(rdd, (WriteConfig)WriteConfig$.MODULE$.apply(rdd.sparkContext()), evidence$5);
    }

    public <D> void save(RDD<D> rdd, WriteConfig writeConfig, ClassTag<D> evidence$6) {
        this.save(rdd, writeConfig, MongoConnector$.MODULE$.apply(writeConfig.asOptions()), evidence$6);
    }

    public <D> void save(RDD<D> rdd, WriteConfig writeConfig, MongoConnector mongoConnector, ClassTag<D> evidence$7) {
        List queryKeyList = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(BsonDocument.parse((String)((String)writeConfig.shardKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> "{_id: 1}"))).keySet()).asScala()).toList();
        rdd.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            MongoSpark$.$anonfun$save$2(mongoConnector, writeConfig, queryKeyList, iter);
            return BoxedUnit.UNIT;
        });
    }

    public <D> void save(Dataset<D> dataset) {
        this.save(dataset, (WriteConfig)WriteConfig$.MODULE$.apply(dataset.sparkSession().sparkContext().getConf()));
    }

    public <D> void save(Dataset<D> dataset, WriteConfig writeConfig) {
        Function1<Row, BsonDocument> mapper = MapFunctions$.MODULE$.rowToDocumentMapper(dataset.schema(), writeConfig.extendedBsonTypes());
        this.save(dataset.toDF().rdd().map((Function1 & Serializable & scala.Serializable)row -> (BsonDocument)mapper.apply(row), ClassTag$.MODULE$.apply(BsonDocument.class)), writeConfig, ClassTag$.MODULE$.apply(BsonDocument.class));
    }

    public void save(DataFrameWriter<?> dataFrameWriter) {
        dataFrameWriter.format(this.defaultSource()).save();
    }

    public void save(DataFrameWriter<?> dataFrameWriter, WriteConfig writeConfig) {
        dataFrameWriter.format(this.defaultSource()).options(writeConfig.asOptions()).save();
    }

    public DataFrameReader read(SparkSession sparkSession) {
        return sparkSession.read().format("com.mongodb.spark.sql");
    }

    public <T> DataFrameWriter<T> write(Dataset<T> dataset) {
        return dataset.write().format("com.mongodb.spark.sql");
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD();
    }

    public JavaMongoRDD<Document> load(JavaSparkContext jsc, ReadConfig readConfig) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD();
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).readConfig(readConfig).build().toJavaRDD(clazz);
    }

    public <D> JavaMongoRDD<D> load(JavaSparkContext jsc, Class<D> clazz) {
        return this.builder().javaSparkContext(jsc).build().toJavaRDD(clazz);
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession) {
        return this.builder().sparkSession(sparkSession).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public Dataset<Row> loadAndInferSchema(SparkSession sparkSession, ReadConfig readConfig) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
    }

    public <D> Dataset<D> load(SparkSession sparkSession, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).build().toDS(clazz);
    }

    public <D> Dataset<D> load(SparkSession sparkSession, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sparkSession).readConfig(readConfig).build().toDS(clazz);
    }

    public void save(JavaRDD<Document> javaRDD) {
        this.save(javaRDD, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        this.save(javaRDD.rdd(), MongoSpark$.ct$1(clazz));
    }

    public void save(JavaRDD<Document> javaRDD, WriteConfig writeConfig) {
        this.save(javaRDD, writeConfig, Document.class);
    }

    public <D> void save(JavaRDD<D> javaRDD, WriteConfig writeConfig, Class<D> clazz) {
        package$.MODULE$.notNull("javaRDD", javaRDD);
        package$.MODULE$.notNull("writeConfig", writeConfig);
        this.save(javaRDD.rdd(), writeConfig, MongoSpark$.ct$2(clazz));
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, TypeTags.TypeTag<D> evidence$8) {
        return this.load(sqlContext.sparkSession(), evidence$8);
    }

    public <D extends Product> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, TypeTags.TypeTag<D> evidence$9) {
        return this.load(sqlContext.sparkSession(), readConfig, evidence$9);
    }

    public <D> Dataset<Row> load(SQLContext sqlContext, ReadConfig readConfig, Class<D> clazz) {
        return this.builder().sparkSession(sqlContext.sparkSession()).readConfig(readConfig).build().toDF(clazz);
    }

    public DataFrameReader read(SQLContext sqlContext) {
        return this.read(sqlContext.sparkSession());
    }

    public MongoSpark apply(SparkSession sparkSession, MongoConnector connector, ReadConfig readConfig) {
        return new MongoSpark(sparkSession, connector, readConfig);
    }

    public Option<Tuple3<SparkSession, MongoConnector, ReadConfig>> unapply(MongoSpark x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.sparkSession(), (Object)x$0.connector(), (Object)x$0.readConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$save$3(Iterator iter$1, WriteConfig writeConfig$1, List queryKeyList$1, MongoCollection collection) {
        iter$1.grouped(writeConfig$1.maxBatchSize()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            Seq requests = (Seq)batch.map((Function1 & Serializable & scala.Serializable)data -> {
                InsertOneModel insertOneModel;
                BsonDocument doc = BsonDocumentWrapper.asBsonDocument((Object)data, (CodecRegistry)collection.getCodecRegistry());
                if (!writeConfig$1.forceInsert() && queryKeyList$1.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)doc.containsKey((Object)x$1)))) {
                    BsonDocument queryDocument = new BsonDocument();
                    queryKeyList$1.foreach((Function1 & Serializable & scala.Serializable)key -> queryDocument.append(key, doc.get(key)));
                    if (writeConfig$1.replaceDocument()) {
                        insertOneModel = new ReplaceOneModel((Bson)queryDocument, (Object)doc, new ReplaceOptions().upsert(true));
                    } else {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(queryDocument.keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> doc.remove(x$2));
                        insertOneModel = new UpdateOneModel((Bson)queryDocument, (Bson)new BsonDocument("$set", (BsonValue)doc), new UpdateOptions().upsert(true));
                    }
                } else {
                    insertOneModel = new InsertOneModel((Object)doc);
                }
                return insertOneModel;
            }, Seq$.MODULE$.canBuildFrom());
            return collection.bulkWrite((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requests.toList()).asJava(), new BulkWriteOptions().ordered(writeConfig$1.ordered()));
        });
    }

    public static final /* synthetic */ void $anonfun$save$2(MongoConnector mongoConnector$1, WriteConfig writeConfig$1, List queryKeyList$1, Iterator iter) {
        block0: {
            if (!iter.nonEmpty()) break block0;
            mongoConnector$1.withCollectionDo((MongoCollectionConfig)writeConfig$1, (Function1 & Serializable & scala.Serializable)collection -> {
                MongoSpark$.$anonfun$save$3(iter, writeConfig$1, queryKeyList$1, collection);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(BsonDocument.class));
        }
    }

    private static final ClassTag ct$1(Class clazz$1) {
        return ClassTag$.MODULE$.apply(clazz$1);
    }

    private static final ClassTag ct$2(Class clazz$2) {
        return ClassTag$.MODULE$.apply(clazz$2);
    }

    private MongoSpark$() {
        MODULE$ = this;
        this.defaultSource = "com.mongodb.spark.sql";
    }
}

