/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerVersion;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoClientFactory;
import com.mongodb.spark.MongoConnector$;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.WriteConfig;
import com.mongodb.spark.package$;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005w!\u0002\u0016,\u0011\u0003\u0011d!\u0002\u001b,\u0011\u0003)\u0004\"B \u0002\t\u0003\u0001\u0005\"B!\u0002\t\u0003\u0011\u0005BB!\u0002\t\u0003\u00119\u0004\u0003\u0004B\u0003\u0011\u0005!1\t\u0005\u0007\u0003\u0006!\tAa\u0012\t\u000f\t]\u0013\u0001\"\u0001\u0003Z!9!qK\u0001\u0005\u0002\t\u001d\u0004b\u0002B,\u0003\u0011\u0005!1\u000e\u0005\b\u0005/\nA\u0011\u0001B=\u0011)\u0011i(\u0001b\u0001\n\u0003Y#q\u0010\u0005\t\u0005#\u000b\u0001\u0015!\u0003\u0003\u0002\"I!1S\u0001C\u0002\u0013%!Q\u0013\u0005\t\u0005G\u000b\u0001\u0015!\u0003\u0003\u0018\"A\u0011)AA\u0001\n\u0003\u0013)\u000bC\u0005\u0003*\u0006\t\t\u0011\"!\u0003,\"I!qW\u0001\u0002\u0002\u0013%!\u0011\u0018\u0004\u0005i-\u0002E\t\u0003\u0005V%\tU\r\u0011\"\u0001W\u0011!Q&C!E!\u0002\u00139\u0006\"B \u0013\t\u0003Y\u0006\"B/\u0013\t\u0003q\u0006\"\u0002<\u0013\t\u00039\bbBA\b%\u0011\u0005\u0011\u0011\u0003\u0005\u0007;J!\t!!\u0010\t\rY\u0014B\u0011AA2\u0011\u001d\tyA\u0005C\u0001\u0003cB\u0001\"a(\u0013\t\u0003Y\u0013\u0011\u0015\u0005\t\u0003g\u0013B\u0011A\u0016\u00026\"A\u0011q\u0017\n\u0005\u0002-\nI\fC\u0004\u0002DJ!\t%!2\t\u0013\u0005\u001d'#!A\u0005\u0002\u0005%\u0007\"CAg%E\u0005I\u0011AAh\u0011%\t)OEA\u0001\n\u0003\n9\u000fC\u0005\u0002vJ\t\t\u0011\"\u0001\u0002x\"I\u0011q \n\u0002\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u000f\u0011\u0012\u0011!C!\u0005\u0013A\u0011Ba\u0006\u0013\u0003\u0003%\tA!\u0007\t\u0013\tu!#!A\u0005B\t}\u0001\"\u0003B\u0011%\u0005\u0005I\u0011\tB\u0012\u0011%\u0011)CEA\u0001\n\u0003\u00129#\u0001\bN_:<wnQ8o]\u0016\u001cGo\u001c:\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u001diwN\\4pI\nT\u0011\u0001M\u0001\u0004G>l7\u0001\u0001\t\u0003g\u0005i\u0011a\u000b\u0002\u000f\u001b>twm\\\"p]:,7\r^8s'\r\ta\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t!'A\u0003baBd\u0017\u0010F\u0002D\u0005W\u0001\"a\r\n\u0014\rI)\u0005j\u0014*=!\t\u0019d)\u0003\u0002HW\t9Aj\\4hS:<\u0007CA%O\u001b\u0005Q%BA&M\u0003\tIwNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005yR\u0005CA%Q\u0013\t\t&JA\u0005DY>\u001cX-\u00192mKB\u0011qgU\u0005\u0003)b\u0012q\u0001\u0015:pIV\u001cG/\u0001\nn_:<wn\u00117jK:$h)Y2u_JLX#A,\u0011\u0005MB\u0016BA-,\u0005IiuN\\4p\u00072LWM\u001c;GC\u000e$xN]=\u0002'5|gnZ8DY&,g\u000e\u001e$bGR|'/\u001f\u0011\u0015\u0005\rc\u0006\"B+\u0016\u0001\u00049\u0016!E<ji\"luN\\4p\u00072LWM\u001c;E_V\u0011qL\u0019\u000b\u0003A.\u0004\"!\u00192\r\u0001\u0011)1M\u0006b\u0001I\n\tA+\u0005\u0002fQB\u0011qGZ\u0005\u0003Ob\u0012qAT8uQ&tw\r\u0005\u00028S&\u0011!\u000e\u000f\u0002\u0004\u0003:L\b\"\u00027\u0017\u0001\u0004i\u0017\u0001B2pI\u0016\u0004Ba\u000e8qA&\u0011q\u000e\u000f\u0002\n\rVt7\r^5p]F\u0002\"!\u001d;\u000e\u0003IT!a]\u0017\u0002\r\rd\u0017.\u001a8u\u0013\t)(OA\u0006N_:<wn\u00117jK:$\u0018AD<ji\"$\u0015\r^1cCN,Gi\\\u000b\u0003qj$B!_>\u0002\u0006A\u0011\u0011M\u001f\u0003\u0006G^\u0011\r\u0001\u001a\u0005\u0006y^\u0001\r!`\u0001\u0007G>tg-[4\u0011\u0007y\f\t!D\u0001\u0000\u0015\ta8&C\u0002\u0002\u0004}\u0014Q#T8oO>\u001cu\u000e\u001c7fGRLwN\\\"p]\u001aLw\r\u0003\u0004m/\u0001\u0007\u0011q\u0001\t\u0006o9\fI!\u001f\t\u0004c\u0006-\u0011bAA\u0007e\niQj\u001c8h_\u0012\u000bG/\u00192bg\u0016\f\u0001c^5uQ\u000e{G\u000e\\3di&|g\u000eR8\u0016\r\u0005M\u0011QFA\r)\u0019\t)\"!\r\u00024Q!\u0011qCA\u000e!\r\t\u0017\u0011\u0004\u0003\u0006Gb\u0011\r\u0001\u001a\u0005\b\u0003;A\u00029AA\u0010\u0003\t\u0019G\u000f\u0005\u0004\u0002\"\u0005\u001d\u00121F\u0007\u0003\u0003GQ1!!\n9\u0003\u001d\u0011XM\u001a7fGRLA!!\u000b\u0002$\tA1\t\\1tgR\u000bw\rE\u0002b\u0003[!a!a\f\u0019\u0005\u0004!'!\u0001#\t\u000bqD\u0002\u0019A?\t\r1D\u0002\u0019AA\u001b!\u00199d.a\u000e\u0002\u0018A)\u0011/!\u000f\u0002,%\u0019\u00111\b:\u0003\u001f5{gnZ8D_2dWm\u0019;j_:,B!a\u0010\u0002DQ!\u0011\u0011IA#!\r\t\u00171\t\u0003\u0006Gf\u0011\r\u0001\u001a\u0005\u0007Yf\u0001\r!a\u0012\u0011\u000f\u0005%\u0013q\f9\u0002B5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0005gk:\u001cG/[8o\u0015\ri\u0015\u0011\u000b\u0006\u0005\u0003'\n)&A\u0002ba&T1\u0001LA,\u0015\u0011\tI&a\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002L\tAa)\u001e8di&|g.\u0006\u0003\u0002f\u0005%DCBA4\u0003W\ni\u0007E\u0002b\u0003S\"Qa\u0019\u000eC\u0002\u0011DQ\u0001 \u000eA\u0002uDa\u0001\u001c\u000eA\u0002\u0005=\u0004\u0003CA%\u0003?\nI!a\u001a\u0016\r\u0005M\u0014qSA<)!\t)(!\u001f\u0002|\u0005e\u0005cA1\u0002x\u0011)1m\u0007b\u0001I\")Ap\u0007a\u0001{\"9\u0011QP\u000eA\u0002\u0005}\u0014!B2mCjT\bCBAA\u0003\u001f\u000b)J\u0004\u0003\u0002\u0004\u0006-\u0005cAACq5\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u000b\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u000eb\na\u0001\u0015:fI\u00164\u0017\u0002BAI\u0003'\u0013Qa\u00117bgNT1!!$9!\r\t\u0017q\u0013\u0003\u0007\u0003_Y\"\u0019\u00013\t\r1\\\u0002\u0019AAN!!\tI%a\u0018\u0002\u001e\u0006U\u0004#B9\u0002:\u0005U\u0015A\u00075bgN\u000bW\u000e\u001d7f\u0003\u001e<'/Z4bi\u0016|\u0005/\u001a:bi>\u0014H\u0003BAR\u0003S\u00032aNAS\u0013\r\t9\u000b\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\u000b\ba\u0001\u0003[\u000b!B]3bI\u000e{gNZ5h!\rq\u0018qV\u0005\u0004\u0003c{(A\u0003*fC\u0012\u001cuN\u001c4jO\u0006i\u0011mY9vSJ,7\t\\5f]R$\u0012\u0001]\u0001\u000ee\u0016dW-Y:f\u00072LWM\u001c;\u0015\t\u0005m\u0016\u0011\u0019\t\u0004o\u0005u\u0016bAA`q\t!QK\\5u\u0011\u0015\u0019h\u00041\u0001q\u0003\u0015\u0019Gn\\:f)\t\tY,\u0001\u0003d_BLHcA\"\u0002L\"9Q\u000b\tI\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#T3aVAjW\t\t)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\u0013Ut7\r[3dW\u0016$'bAApq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0018\u0011\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002p2\u000bA\u0001\\1oO&!\u00111_Aw\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011 \t\u0004o\u0005m\u0018bAA\u007fq\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001Na\u0001\t\u0013\t\u0015A%!AA\u0002\u0005e\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\fA)!Q\u0002B\nQ6\u0011!q\u0002\u0006\u0004\u0005#A\u0014AC2pY2,7\r^5p]&!!Q\u0003B\b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r&1\u0004\u0005\t\u0005\u000b1\u0013\u0011!a\u0001Q\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002z\u0006AAo\\*ue&tw\r\u0006\u0002\u0002j\u00061Q-];bYN$B!a)\u0003*!A!QA\u0015\u0002\u0002\u0003\u0007\u0001\u000eC\u0004\u0003.\r\u0001\rAa\f\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0011\t\tE\"1G\u0007\u0003\u0003+JAA!\u000e\u0002V\ta1\u000b]1sW\u000e{g\u000e^3yiR\u00191I!\u000f\t\u000f\tmB\u00011\u0001\u0003>\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0005\u0005c\u0011y$\u0003\u0003\u0003B\u0005U#!C*qCJ\\7i\u001c8g)\r\u0019%Q\t\u0005\b\u0003W+\u0001\u0019AAW)\r\u0019%\u0011\n\u0005\b\u0005\u00172\u0001\u0019\u0001B'\u0003\u001dy\u0007\u000f^5p]N\u0004\u0002B!\u0004\u0003P\tM#1K\u0005\u0005\u0005#\u0012yAA\u0002NCB\u0004B!!!\u0003V%!\u00111_AJ\u0003\u0019\u0019'/Z1uKR\u00191Ia\u0017\t\u000f\tus\u00011\u0001\u0003`\u0005\u0001\".\u0019<b'B\f'o[\"p]R,\u0007\u0010\u001e\t\u0005\u0005C\u0012\u0019'\u0004\u0002\u0002P%!!QMA(\u0005AQ\u0015M^1Ta\u0006\u00148nQ8oi\u0016DH\u000fF\u0002D\u0005SBqAa\u000f\t\u0001\u0004\u0011i\u0004F\u0002D\u0005[BqAa\u0013\n\u0001\u0004\u0011y\u0007\u0005\u0005\u0003r\t]$1\u000bB*\u001b\t\u0011\u0019HC\u0002\u0003v1\u000bA!\u001e;jY&!!\u0011\u000bB:)\r\u0019%1\u0010\u0005\u0006+*\u0001\raV\u0001\u0015[>twm\\\"mS\u0016tGoS3fa\u0006c\u0017N^3\u0016\u0005\t\u0005\u0005\u0003\u0002BB\u0005\u001bk!A!\"\u000b\t\t\u001d%\u0011R\u0001\tIV\u0014\u0018\r^5p]*\u0019!1\u0012\u001d\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003\u0010\n\u0015%A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0016[>twm\\\"mS\u0016tGoS3fa\u0006c\u0017N^3!\u0003AiwN\\4p\u00072LWM\u001c;DC\u000eDW-\u0006\u0002\u0003\u0018B!!\u0011\u0014BP\u001b\t\u0011YJC\u0002\u0003\u001e.\n!bY8o]\u0016\u001cG/[8o\u0013\u0011\u0011\tKa'\u0003!5{gnZ8DY&,g\u000e^\"bG\",\u0017!E7p]\u001e|7\t\\5f]R\u001c\u0015m\u00195fAQ\u00191Ia*\t\u000bU{\u0001\u0019A,\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0016BZ!\u00119$qV,\n\u0007\tE\u0006H\u0001\u0004PaRLwN\u001c\u0005\t\u0005k\u0003\u0012\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005w\u0003B!a;\u0003>&!!qXAw\u0005\u0019y%M[3di\u0002")
public class MongoConnector
extends Logging
implements Closeable,
Product,
scala.Serializable {
    private final MongoClientFactory mongoClientFactory;

    public static Option<MongoClientFactory> unapply(MongoConnector mongoConnector) {
        return MongoConnector$.MODULE$.unapply(mongoConnector);
    }

    public static MongoConnector apply(MongoClientFactory mongoClientFactory) {
        return MongoConnector$.MODULE$.apply(mongoClientFactory);
    }

    public static MongoConnector create(MongoClientFactory mongoClientFactory) {
        return MongoConnector$.MODULE$.create(mongoClientFactory);
    }

    public static MongoConnector create(java.util.Map<String, String> map) {
        return MongoConnector$.MODULE$.create(map);
    }

    public static MongoConnector create(SparkConf sparkConf) {
        return MongoConnector$.MODULE$.create(sparkConf);
    }

    public static MongoConnector create(JavaSparkContext javaSparkContext) {
        return MongoConnector$.MODULE$.create(javaSparkContext);
    }

    public static MongoConnector apply(Map<String, String> map) {
        return MongoConnector$.MODULE$.apply(map);
    }

    public static MongoConnector apply(ReadConfig readConfig) {
        return MongoConnector$.MODULE$.apply(readConfig);
    }

    public static MongoConnector apply(SparkConf sparkConf) {
        return MongoConnector$.MODULE$.apply(sparkConf);
    }

    public static MongoConnector apply(SparkContext sparkContext) {
        return MongoConnector$.MODULE$.apply(sparkContext);
    }

    public MongoClientFactory mongoClientFactory() {
        return this.mongoClientFactory;
    }

    public <T> T withMongoClientDo(Function1<MongoClient, T> code) {
        Object object;
        MongoClient client = this.acquireClient();
        try {
            object = code.apply((Object)client);
        }
        finally {
            this.releaseClient(client);
        }
        return (T)object;
    }

    public <T> T withDatabaseDo(MongoCollectionConfig config, Function1<MongoDatabase, T> code) {
        return this.withMongoClientDo((Function1 & Serializable & scala.Serializable)client -> code.apply((Object)client.getDatabase(config.databaseName())));
    }

    public <D, T> T withCollectionDo(MongoCollectionConfig config, Function1<MongoCollection<D>, T> code, ClassTag<D> ct) {
        return this.withDatabaseDo(config, (Function1 & Serializable & scala.Serializable)db -> {
            MongoCollection mongoCollection;
            MongoCollection collection = db.getCollection(config.collectionName(), package$.MODULE$.classTagToClassOf(ct));
            MongoCollectionConfig mongoCollectionConfig = config;
            if (mongoCollectionConfig instanceof WriteConfig) {
                WriteConfig writeConfig = (WriteConfig)mongoCollectionConfig;
                mongoCollection = collection.withWriteConcern(writeConfig.writeConcern());
            } else if (mongoCollectionConfig instanceof ReadConfig) {
                ReadConfig readConfig = (ReadConfig)mongoCollectionConfig;
                mongoCollection = collection.withReadConcern(readConfig.readConcern()).withReadPreference(readConfig.readPreference());
            } else {
                mongoCollection = collection;
            }
            return code.apply((Object)mongoCollection);
        });
    }

    public <T> T withMongoClientDo(Function<MongoClient, T> code) {
        return this.withMongoClientDo((Function1 & Serializable & scala.Serializable)client -> code.call(client));
    }

    public <T> T withDatabaseDo(MongoCollectionConfig config, Function<MongoDatabase, T> code) {
        return this.withDatabaseDo(config, (Function1 & Serializable & scala.Serializable)mongoDatabase -> code.call(mongoDatabase));
    }

    public <D, T> T withCollectionDo(MongoCollectionConfig config, Class<D> clazz, Function<MongoCollection<D>, T> code) {
        return this.withCollectionDo(config, (Function1 & Serializable & scala.Serializable)collection -> code.call(collection), MongoConnector.ct$2(clazz));
    }

    public boolean hasSampleAggregateOperator(ReadConfig readConfig) {
        BsonDocument buildInfo = (BsonDocument)this.withDatabaseDo((MongoCollectionConfig)readConfig, (Function1 & Serializable & scala.Serializable)db -> (BsonDocument)db.runCommand((Bson)new Document("buildInfo", (Object)BoxesRunTime.boxToInteger((int)1)), BsonDocument.class));
        List versionArray = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)buildInfo.getArray((Object)"versionArray")).asScala()).take(3)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.asInt32().getValue()), Buffer$.MODULE$.canBuildFrom())).asJava();
        return new ServerVersion(versionArray).compareTo(new ServerVersion(3, 2)) >= 0;
    }

    public MongoClient acquireClient() {
        return MongoConnector$.MODULE$.com$mongodb$spark$MongoConnector$$mongoClientCache().acquire(this.mongoClientFactory());
    }

    public void releaseClient(MongoClient client) {
        MongoConnector$.MODULE$.com$mongodb$spark$MongoConnector$$mongoClientCache().release(client, MongoConnector$.MODULE$.com$mongodb$spark$MongoConnector$$mongoClientCache().release$default$2());
    }

    @Override
    public void close() {
        MongoConnector$.MODULE$.com$mongodb$spark$MongoConnector$$mongoClientCache().shutdown();
    }

    public MongoConnector copy(MongoClientFactory mongoClientFactory) {
        return new MongoConnector(mongoClientFactory);
    }

    public MongoClientFactory copy$default$1() {
        return this.mongoClientFactory();
    }

    public String productPrefix() {
        return "MongoConnector";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.mongoClientFactory();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MongoConnector;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MongoConnector)) return false;
        boolean bl = true;
        if (!bl) return false;
        MongoConnector mongoConnector = (MongoConnector)x$1;
        MongoClientFactory mongoClientFactory = this.mongoClientFactory();
        MongoClientFactory mongoClientFactory2 = mongoConnector.mongoClientFactory();
        if (mongoClientFactory == null) {
            if (mongoClientFactory2 != null) {
                return false;
            }
        } else if (!mongoClientFactory.equals(mongoClientFactory2)) return false;
        if (!mongoConnector.canEqual(this)) return false;
        return true;
    }

    private static final ClassTag ct$2(Class clazz$1) {
        return ClassTag$.MODULE$.apply(clazz$1);
    }

    public MongoConnector(MongoClientFactory mongoClientFactory) {
        this.mongoClientFactory = mongoClientFactory;
        Product.$init$((Product)this);
    }
}

