/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.annotation.DeveloperApi;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import java.io.Serializable;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class PartitionerHelper$ {
    public static PartitionerHelper$ MODULE$;
    private final List<String> EXCLUDE_KEYS;
    private final String AND_KEY;

    static {
        new PartitionerHelper$();
    }

    public BsonDocument createBoundaryQuery(String key, BsonValue lower, BsonValue upper) {
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)lower).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "lower range partition key missing");
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)upper).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "upper range partition key missing");
        BsonDocument queryBoundry = new BsonDocument();
        Object object = !(lower instanceof BsonMinKey) ? queryBoundry.append("$gte", lower) : BoxedUnit.UNIT;
        Object object2 = !(upper instanceof BsonMaxKey) ? queryBoundry.append("$lt", upper) : BoxedUnit.UNIT;
        return queryBoundry.isEmpty() ? queryBoundry : new BsonDocument(key, (BsonValue)queryBoundry);
    }

    public MongoPartition[] createPartitions(String partitionKey, Seq<BsonValue> splitKeys, Seq<String> locations, boolean addMinMax) {
        Seq seq;
        Tuple2 minKeyMaxKeys = new Tuple2((Object)new BsonMinKey(), (Object)new BsonMaxKey());
        if (addMinMax) {
            BsonMinKey bsonMinKey = (BsonMinKey)minKeyMaxKeys._1();
            seq = (Seq)((SeqLike)splitKeys.$plus$colon((Object)bsonMinKey, Seq$.MODULE$.canBuildFrom())).$colon$plus(minKeyMaxKeys._2(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = splitKeys;
        }
        Seq minToMaxSplitKeys = seq;
        Seq minToMaxKeysToPartition = minToMaxSplitKeys.length() <= 1 ? minToMaxSplitKeys : (Seq)minToMaxSplitKeys.tail();
        Seq partitionPairs = (Seq)minToMaxSplitKeys.zip((GenIterable)minToMaxKeysToPartition, Seq$.MODULE$.canBuildFrom());
        return partitionPairs.isEmpty() ? (MongoPartition[])((Object[])new MongoPartition[]{new MongoPartition(0, new BsonDocument(), locations)}) : (MongoPartition[])((TraversableOnce)((TraversableLike)partitionPairs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BsonValue bsonValue;
            BsonValue max;
            int i;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    i = tuple2._2$mcI$sp();
                    if (tuple22 == null) break block2;
                    BsonValue min = (BsonValue)tuple22._1();
                    max = (BsonValue)tuple22._2();
                    if (min == null) break block2;
                    bsonValue = min;
                    if (max != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            BsonValue bsonValue2 = max;
            int n = i;
            MongoPartition mongoPartition = new MongoPartition(n, MODULE$.createBoundaryQuery(partitionKey, bsonValue, bsonValue2), locations);
            return mongoPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MongoPartition.class));
    }

    public Seq<String> createPartitions$default$3() {
        return Nil$.MODULE$;
    }

    public boolean createPartitions$default$4() {
        return true;
    }

    public Seq<String> locations(MongoConnector connector) {
        return (Seq)connector.withMongoClientDo((Function1 & Serializable & scala.Serializable)mongoClient -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mongoClient.getClusterDescription().getClusterSettings().getHosts()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHost(), Buffer$.MODULE$.canBuildFrom()));
    }

    public BsonDocument collStats(MongoConnector connector, ReadConfig readConfig) {
        BsonDocument collStatsCommand = new BsonDocument("collStats", (BsonValue)new BsonString(readConfig.collectionName()));
        return (BsonDocument)connector.withDatabaseDo((MongoCollectionConfig)readConfig, (Function1 & Serializable & scala.Serializable)db -> (BsonDocument)db.runCommand((Bson)collStatsCommand, readConfig.readPreference(), BsonDocument.class));
    }

    public BsonDocument matchQuery(BsonDocument[] pipeline) {
        BsonDocument bsonDocument;
        BsonDocument defaultQuery = new BsonDocument();
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipeline)).headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            BsonDocument document = (BsonDocument)some.value();
            bsonDocument = this.removeExistsAndNeChecks((BsonValue)document.getDocument((Object)"$match", defaultQuery)).asDocument();
        } else if (None$.MODULE$.equals(option)) {
            bsonDocument = defaultQuery;
        } else {
            throw new MatchError((Object)option);
        }
        return bsonDocument;
    }

    private List<String> EXCLUDE_KEYS() {
        return this.EXCLUDE_KEYS;
    }

    /*
     * WARNING - void declaration
     */
    private BsonValue removeExistsAndNeChecks(BsonValue value) {
        BsonValue bsonValue;
        if (value.isDocument() && !value.asDocument().isEmpty()) {
            void var2_2;
            BsonDocument cleanedDocument = new BsonDocument();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)value.asDocument()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    BsonValue v = (BsonValue)tuple2._2();
                    if (k != null) {
                        String string = k;
                        if (v instanceof BsonDocument) {
                            BsonDocument bsonDocument = (BsonDocument)v;
                            BsonDocument cleanedSubDocument = new BsonDocument();
                            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)bsonDocument.asDocument()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                String string;
                                BsonValue sv;
                                block3: {
                                    Tuple2 tuple2;
                                    block2: {
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block2;
                                        String sk = (String)tuple2._1();
                                        sv = (BsonValue)tuple2._2();
                                        if (sk == null) break block2;
                                        string = sk;
                                        if (sv != null) break block3;
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                BsonValue bsonValue = sv;
                                BoxedUnit boxedUnit = !MODULE$.EXCLUDE_KEYS().contains((Object)string) ? cleanedSubDocument.put(string, MODULE$.removeExistsAndNeChecks(bsonValue)) : BoxedUnit.UNIT;
                                return boxedUnit;
                            });
                            return !cleanedSubDocument.isEmpty() ? cleanedDocument.put(string, (BsonValue)cleanedSubDocument) : BoxedUnit.UNIT;
                        }
                    }
                }
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    BsonValue v = (BsonValue)tuple2._2();
                    if (k != null) {
                        String string = k;
                        if (v instanceof BsonArray) {
                            BsonArray bsonArray = (BsonArray)v;
                            BsonArray cleanedArray = MODULE$.removeExistsAndNeChecksFromBsonArray(string, bsonArray);
                            return !cleanedArray.isEmpty() ? cleanedDocument.put(string, (BsonValue)cleanedArray) : BoxedUnit.UNIT;
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String k = (String)tuple2._1();
                BsonValue v = (BsonValue)tuple2._2();
                if (k == null) throw new MatchError((Object)tuple2);
                String string = k;
                if (v == null) throw new MatchError((Object)tuple2);
                BsonValue bsonValue = v;
                return cleanedDocument.put(string, bsonValue);
            });
            bsonValue = var2_2;
        } else {
            bsonValue = value;
        }
        return bsonValue;
    }

    private String AND_KEY() {
        return this.AND_KEY;
    }

    public BsonArray removeExistsAndNeChecksFromBsonArray(String k, BsonArray v) {
        BsonArray bsonArray;
        String string = k;
        String string2 = this.AND_KEY();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            BsonArray cleanedArray = new BsonArray();
            v.asArray().forEach(bv -> {
                if (bv.isDocument()) {
                    BsonValue cleanedSubDocument = MODULE$.removeExistsAndNeChecks((BsonValue)bv);
                    if (!cleanedSubDocument.asDocument().isEmpty()) {
                        cleanedArray.add(cleanedSubDocument);
                    }
                } else {
                    cleanedArray.add(bv);
                }
            });
            bsonArray = cleanedArray;
        } else {
            bsonArray = v;
        }
        return bsonArray;
    }

    public Tuple2<BsonValue, BsonValue> getSplitVectorRangeQuery(String partitionKey, BsonDocument[] pipeline) {
        BsonDocument bsonDocument;
        Some some;
        BsonDocument document;
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipeline)).headOption();
        if (option instanceof Some && (document = (BsonDocument)(some = (Some)option).value()) != null) {
            BsonDocument bsonDocument2 = document;
            bsonDocument = this.getNestedDocument((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$match", partitionKey}))), bsonDocument2);
        } else if (None$.MODULE$.equals(option)) {
            bsonDocument = new BsonDocument();
        } else {
            throw new MatchError((Object)option);
        }
        BsonDocument filter = bsonDocument;
        return new Tuple2((Object)filter.get((Object)"$gte", (BsonValue)new BsonMinKey()), (Object)filter.get((Object)"$lt", (BsonValue)new BsonMaxKey()));
    }

    public MongoPartition[] setLastBoundaryToLessThanOrEqualTo(String partitionKey, MongoPartition[] partitions) {
        BoxedUnit boxedUnit;
        if (partitions.length > 0) {
            MongoPartition lastPartition = (MongoPartition)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).reverse())).head();
            BsonDocument partitionQuery = lastPartition.queryBounds().getDocument((Object)partitionKey);
            boxedUnit = partitionQuery.append("$lte", partitionQuery.remove((Object)"$lt"));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return partitions;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BsonDocument getNestedDocument(Seq<String> keys, BsonDocument document) {
        BsonDocument bsonDocument;
        while (keys.nonEmpty() && document.containsKey(keys.head())) {
            BsonValue bsonValue = document.get(keys.head());
            if (!bsonValue.isDocument()) {
                bsonDocument = new BsonDocument();
                return bsonDocument;
            }
            BsonDocument subDoc = bsonValue.asDocument();
            if (((SeqLike)keys.tail()).isEmpty()) {
                bsonDocument = subDoc;
                return bsonDocument;
            }
            document = subDoc;
            keys = (Seq)keys.tail();
        }
        bsonDocument = this.checkForKeysInNestedAndQuery((Seq<String>)keys, document);
        return bsonDocument;
    }

    private BsonDocument checkForKeysInNestedAndQuery(Seq<String> keys, BsonDocument document) {
        BsonDocument bsonDocument;
        if (keys.length() == 1 && document.containsKey((Object)this.AND_KEY()) && document.isArray((Object)this.AND_KEY())) {
            String key = (String)keys.head();
            Buffer documentValues = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.removeExistsAndNeChecksFromBsonArray(this.AND_KEY(), document.getArray((Object)this.AND_KEY())).asArray().getValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asDocument(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)PartitionerHelper$.$anonfun$checkForKeysInNestedAndQuery$2(key, d)));
            BsonDocument valueDoc = new BsonDocument();
            documentValues.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                PartitionerHelper$.$anonfun$checkForKeysInNestedAndQuery$3(key, valueDoc, x$4);
                return BoxedUnit.UNIT;
            });
            bsonDocument = valueDoc;
        } else {
            bsonDocument = new BsonDocument();
        }
        return bsonDocument;
    }

    public static final /* synthetic */ boolean $anonfun$checkForKeysInNestedAndQuery$2(String key$1, BsonDocument d) {
        return d.containsKey((Object)key$1) && d.get((Object)key$1).isDocument();
    }

    public static final /* synthetic */ void $anonfun$checkForKeysInNestedAndQuery$3(String key$1, BsonDocument valueDoc$1, BsonDocument x$4) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(x$4.getDocument((Object)key$1).entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> valueDoc$1.append((String)e.getKey(), (BsonValue)e.getValue()));
    }

    private PartitionerHelper$() {
        MODULE$ = this;
        this.EXCLUDE_KEYS = new .colon.colon((Object)"$exists", (List)new .colon.colon((Object)"$ne", (List)Nil$.MODULE$));
        this.AND_KEY = "$and";
    }
}

