/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.rdd.partitioner;

import com.mongodb.ServerAddress;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.spark.Logging;
import com.mongodb.spark.MongoConnector;
import com.mongodb.spark.config.MongoCollectionConfig;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import com.mongodb.spark.rdd.partitioner.MongoPartition;
import com.mongodb.spark.rdd.partitioner.MongoPartitioner;
import com.mongodb.spark.rdd.partitioner.MongoShardedPartitioner$;
import com.mongodb.spark.rdd.partitioner.MongoSinglePartitioner$;
import com.mongodb.spark.rdd.partitioner.PartitionerHelper$;
import java.io.Serializable;
import java.util.ArrayList;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u0011\"\u00011BQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003:\u0011\u0019!\u0005\u0001)A\u0005u!9Q\t\u0001b\u0001\n\u0013I\u0004B\u0002$\u0001A\u0003%!\bC\u0004H\u0001\t\u0007I\u0011B\u001d\t\r!\u0003\u0001\u0015!\u0003;\u0011\u001dI\u0005A1A\u0005\neBaA\u0013\u0001!\u0002\u0013Q\u0004bB&\u0001\u0005\u0004%\t\u0001\u0014\u0005\u00073\u0002\u0001\u000b\u0011B'\t\u000bi\u0003A\u0011I.\t\rm\u0004A\u0011A\u0011}\u0011!\t\t\u0003\u0001C\u0001C\u0005\r\u0002\u0002CA\u0016\u0001\u0011\u0005\u0011%!\f\t\u0011\u0005U\u0002\u0001\"\u0001\"\u0003oA\u0001\"a\u000f\u0001\t\u0003\t\u0013Q\b\u0005\t\u0003\u0007\u0002A\u0011A\u0011\u0002F\u001d9\u00111J\u0011\t\u0002\u00065cA\u0002\u0011\"\u0011\u0003\u000by\u0005\u0003\u00046-\u0011\u0005\u0011Q\f\u0005\t\u0003?2\u0012\u0011!C!s!I\u0011\u0011\r\f\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003W2\u0012\u0011!C\u0001\u0003[B\u0011\"!\u001f\u0017\u0003\u0003%\t%a\u001f\t\u0013\u0005%e#!A\u0005\u0002\u0005-\u0005\"CAK-\u0005\u0005I\u0011IAL\u0011%\tIJFA\u0001\n\u0003\nY\nC\u0005\u0002\u001eZ\t\t\u0011\"\u0003\u0002 \n9Rj\u001c8h_NC\u0017M\u001d3fIB\u000b'\u000f^5uS>tWM\u001d\u0006\u0003E\r\n1\u0002]1si&$\u0018n\u001c8fe*\u0011A%J\u0001\u0004e\u0012$'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&A\u0004n_:<w\u000e\u001a2\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00172!\tqs&D\u0001&\u0013\t\u0001TEA\u0004M_\u001e<\u0017N\\4\u0011\u0005I\u001aT\"A\u0011\n\u0005Q\n#\u0001E'p]\u001e|\u0007+\u0019:uSRLwN\\3s\u0003\u0019a\u0014N\\5u}Q\tq\u0007\u0005\u00023\u0001\u0005yA)\u001a4bk2$8\u000b[1sI.+\u00170F\u0001;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012aa\u0015;sS:<\u0017\u0001\u0005#fM\u0006,H\u000e^*iCJ$7*Z=!\u0003!IEi\u0018$J\u000b2#\u0015!C%E?\u001aKU\t\u0014#!\u0003=q\u0015)T#T!\u0006\u001bUi\u0018$J\u000b2#\u0015\u0001\u0005(B\u001b\u0016\u001b\u0006+Q\"F?\u001aKU\t\u0014#!\u0003))V+\u0013#`\r&+E\nR\u0001\f+VKEi\u0018$J\u000b2#\u0005%A\u0007E%>\u0003\u0006+\u0012#`\r&+E\nR\u0001\u000f\tJ{\u0005\u000bU#E?\u001aKU\t\u0014#!\u0003A\u0019\b.\u0019:e\u0017\u0016L\bK]8qKJ$\u00180F\u0001N!\tquK\u0004\u0002P+B\u0011\u0001kU\u0007\u0002#*\u0011!kK\u0001\u0007yI|w\u000e\u001e \u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0002\rA\u0013X\rZ3g\u0013\t\t\u0005L\u0003\u0002W'\u0006\t2\u000f[1sI.+\u0017\u0010\u0015:pa\u0016\u0014H/\u001f\u0011\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0006\u0003]G\"\u0004\bcA/_A6\t1+\u0003\u0002`'\n)\u0011I\u001d:bsB\u0011!'Y\u0005\u0003E\u0006\u0012a\"T8oO>\u0004\u0016M\u001d;ji&|g\u000eC\u0003e\u001d\u0001\u0007Q-A\u0005d_:tWm\u0019;peB\u0011aFZ\u0005\u0003O\u0016\u0012a\"T8oO>\u001cuN\u001c8fGR|'\u000fC\u0003j\u001d\u0001\u0007!.\u0001\u0006sK\u0006$7i\u001c8gS\u001e\u0004\"a\u001b8\u000e\u00031T!!\\\u0013\u0002\r\r|gNZ5h\u0013\tyGN\u0001\u0006SK\u0006$7i\u001c8gS\u001eDQ!\u001d\bA\u0002I\f\u0001\u0002]5qK2Lg.\u001a\t\u0004;z\u001b\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011\u00117o\u001c8\u000b\u0003a\f1a\u001c:h\u0013\tQXO\u0001\u0007Cg>tGi\\2v[\u0016tG/\u0001\nhK:,'/\u0019;f!\u0006\u0014H/\u001b;j_:\u001cHC\u0002/~\u0003#\t)\u0002C\u0003\u007f\u001f\u0001\u0007q0\u0001\u0004dQVt7n\u001d\t\u0006\u0003\u0003\tYa\u001d\b\u0005\u0003\u0007\t9AD\u0002Q\u0003\u000bI\u0011\u0001V\u0005\u0004\u0003\u0013\u0019\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyAA\u0002TKFT1!!\u0003T\u0011\u0019\t\u0019b\u0004a\u0001\u001b\u0006A1\u000f[1sI.+\u0017\u0010C\u0004\u0002\u0018=\u0001\r!!\u0007\u0002\u0013MD\u0017M\u001d3t\u001b\u0006\u0004\bC\u0002(\u0002\u001c5\u000by\"C\u0002\u0002\u001ea\u00131!T1q!\u0015\t\t!a\u0003N\u0003m9WM\\3sCR,7+\u001b8hY\u0016\\U-\u001f)beRLG/[8ogR9A,!\n\u0002(\u0005%\u0002\"\u0002@\u0011\u0001\u0004y\bBBA\n!\u0001\u0007Q\nC\u0004\u0002\u0018A\u0001\r!!\u0007\u0002;\u001d,g.\u001a:bi\u0016\u001cu.\u001c9pk:$7*Z=QCJ$\u0018\u000e^5p]N$r\u0001XA\u0018\u0003c\t\u0019\u0004C\u0003\u007f#\u0001\u0007q\u0010\u0003\u0004\u0002\u0014E\u0001\ra\u001d\u0005\b\u0003/\t\u0002\u0019AA\r\u0003%i\u0017\r]*iCJ$7\u000f\u0006\u0003\u0002\u001a\u0005e\u0002\"\u00023\u0013\u0001\u0004)\u0017\u0001C4fi\"{7\u000f^:\u0015\t\u0005}\u0011q\b\u0005\u0007\u0003\u0003\u001a\u0002\u0019A'\u0002\u000b!|7\u000f^:\u0002\u000f\u001d,G\u000fS8tiR\u0019Q*a\u0012\t\r\u0005%C\u00031\u0001N\u0003-Awn\u001d;B]\u0012\u0004vN\u001d;\u0002/5{gnZ8TQ\u0006\u0014H-\u001a3QCJ$\u0018\u000e^5p]\u0016\u0014\bC\u0001\u001a\u0017'\u00191r'!\u0015\u0002XA\u0019Q,a\u0015\n\u0007\u0005U3KA\u0004Qe>$Wo\u0019;\u0011\u0007u\u000bI&C\u0002\u0002\\M\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\u0014\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0007E\u0002^\u0003OJ1!!\u001bT\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty'!\u001e\u0011\u0007u\u000b\t(C\u0002\u0002tM\u00131!\u00118z\u0011%\t9HGA\u0001\u0002\u0004\t)'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003{\u0002b!a \u0002\u0006\u0006=TBAAA\u0015\r\t\u0019iU\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAD\u0003\u0003\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QRAJ!\ri\u0016qR\u0005\u0004\u0003#\u001b&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003ob\u0012\u0011!a\u0001\u0003_\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003K\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002u\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u000bE\u0002<\u0003GK1!!*=\u0005\u0019y%M[3di\u0002")
public class MongoShardedPartitioner
extends Logging
implements MongoPartitioner {
    private final String DefaultShardKey;
    private final String ID_FIELD;
    private final String NAMESPACE_FIELD;
    private final String UUID_FIELD;
    private final String DROPPED_FIELD;
    private final String shardKeyProperty = "shardKey".toLowerCase();

    public static boolean canEqual(Object object) {
        return MongoShardedPartitioner$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return MongoShardedPartitioner$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return MongoShardedPartitioner$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return MongoShardedPartitioner$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return MongoShardedPartitioner$.MODULE$.productPrefix();
    }

    private String DefaultShardKey() {
        return this.DefaultShardKey;
    }

    private String ID_FIELD() {
        return this.ID_FIELD;
    }

    private String NAMESPACE_FIELD() {
        return this.NAMESPACE_FIELD;
    }

    private String UUID_FIELD() {
        return this.UUID_FIELD;
    }

    private String DROPPED_FIELD() {
        return this.DROPPED_FIELD;
    }

    public String shardKeyProperty() {
        return this.shardKeyProperty;
    }

    @Override
    public MongoPartition[] partitions(MongoConnector connector, ReadConfig readConfig, BsonDocument[] pipeline) {
        MongoPartition[] mongoPartitionArray;
        String ns = new StringBuilder(1).append(readConfig.databaseName()).append(".").append(readConfig.collectionName()).toString();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Getting split bounds for a sharded collection: ").append(ns).toString());
        Map partitionerOptions = (Map)readConfig.partitionerOptions().map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((String)kv._1()).toLowerCase(), kv._2()), Map$.MODULE$.canBuildFrom());
        String shardKey = (String)partitionerOptions.getOrElse((Object)this.shardKeyProperty(), (Function0 & Serializable & scala.Serializable)() -> this.DefaultShardKey());
        BsonDocument configCollectionMetadata = (BsonDocument)connector.withCollectionDo((MongoCollectionConfig)new ReadConfig("config", "collections", ReadConfig$.MODULE$.apply$default$3(), ReadConfig$.MODULE$.apply$default$4(), ReadConfig$.MODULE$.apply$default$5(), ReadConfig$.MODULE$.apply$default$6(), ReadConfig$.MODULE$.apply$default$7(), ReadConfig$.MODULE$.apply$default$8(), ReadConfig$.MODULE$.apply$default$9(), ReadConfig$.MODULE$.apply$default$10(), ReadConfig$.MODULE$.apply$default$11(), ReadConfig$.MODULE$.apply$default$12(), ReadConfig$.MODULE$.apply$default$13(), ReadConfig$.MODULE$.apply$default$14(), ReadConfig$.MODULE$.apply$default$15(), ReadConfig$.MODULE$.apply$default$16(), ReadConfig$.MODULE$.apply$default$17()), (Function1 & Serializable & scala.Serializable)collection -> (BsonDocument)collection.find(Filters.eq((String)this.ID_FIELD(), (Object)ns)).projection(Projections.include((String[])new String[]{this.ID_FIELD(), this.UUID_FIELD(), this.DROPPED_FIELD()})).first(), ClassTag$.MODULE$.apply(BsonDocument.class));
        if (Option$.MODULE$.apply((Object)configCollectionMetadata).isEmpty() || configCollectionMetadata.getBoolean((Object)this.DROPPED_FIELD(), BsonBoolean.FALSE).getValue()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("Collection '").append(ns).append("' does not appear to be sharded, continuing with a single partition.\n           |To split the collections into multiple partitions connect to the MongoDB node directly").toString())).stripMargin().replaceAll("\n", " "));
            mongoPartitionArray = MongoSinglePartitioner$.MODULE$.partitions(connector, readConfig, MongoSinglePartitioner$.MODULE$.partitions$default$3());
        } else {
            Bson chunksMatchPredicate = Filters.or((Bson[])new Bson[]{new BsonDocument(this.NAMESPACE_FIELD(), configCollectionMetadata.get((Object)this.ID_FIELD())), new BsonDocument(this.UUID_FIELD(), configCollectionMetadata.get((Object)this.UUID_FIELD()))});
            Seq chunks = (Seq)connector.withCollectionDo((MongoCollectionConfig)new ReadConfig("config", "chunks", ReadConfig$.MODULE$.apply$default$3(), ReadConfig$.MODULE$.apply$default$4(), ReadConfig$.MODULE$.apply$default$5(), ReadConfig$.MODULE$.apply$default$6(), ReadConfig$.MODULE$.apply$default$7(), ReadConfig$.MODULE$.apply$default$8(), ReadConfig$.MODULE$.apply$default$9(), ReadConfig$.MODULE$.apply$default$10(), ReadConfig$.MODULE$.apply$default$11(), ReadConfig$.MODULE$.apply$default$12(), ReadConfig$.MODULE$.apply$default$13(), ReadConfig$.MODULE$.apply$default$14(), ReadConfig$.MODULE$.apply$default$15(), ReadConfig$.MODULE$.apply$default$16(), ReadConfig$.MODULE$.apply$default$17()), (Function1 & Serializable & scala.Serializable)collection -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)collection.find(chunksMatchPredicate).projection(Projections.include((String[])new String[]{"min", "max", "shard"})).sort(Sorts.ascending((String[])new String[]{"min"})).into(new ArrayList())).asScala(), ClassTag$.MODULE$.apply(BsonDocument.class));
            if (chunks.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(167).append("Collection '").append(ns).append("' does not appear to be sharded, continuing with a single partition.\nTo split the collections into multiple partitions connect to the MongoDB node directly").toString())).stripMargin().replaceAll("\n", " "));
                mongoPartitionArray = MongoSinglePartitioner$.MODULE$.partitions(connector, readConfig, MongoSinglePartitioner$.MODULE$.partitions$default$3());
            } else {
                mongoPartitionArray = this.generatePartitions((Seq<BsonDocument>)chunks, shardKey, this.mapShards(connector));
            }
        }
        return mongoPartitionArray;
    }

    public MongoPartition[] generatePartitions(Seq<BsonDocument> chunks, String shardKey, scala.collection.immutable.Map<String, Seq<String>> shardsMap) {
        MongoPartition[] mongoPartitionArray;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> BsonDocument.parse((String)shardKey));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BsonDocument shardKeyDocument = (BsonDocument)success.value();
            mongoPartitionArray = this.generateCompoundKeyPartitions(chunks, shardKeyDocument, shardsMap);
        } else if (try_ instanceof Failure) {
            mongoPartitionArray = this.generateSingleKeyPartitions(chunks, shardKey, shardsMap);
        } else {
            throw new MatchError((Object)try_);
        }
        return mongoPartitionArray;
    }

    public MongoPartition[] generateSingleKeyPartitions(Seq<BsonDocument> chunks, String shardKey, scala.collection.immutable.Map<String, Seq<String>> shardsMap) {
        return (MongoPartition[])((TraversableOnce)((TraversableLike)chunks.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int i;
            BsonDocument chunk;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    chunk = (BsonDocument)tuple2._1();
                    i = tuple2._2$mcI$sp();
                    if (chunk != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            BsonDocument bsonDocument = chunk;
            int n = i;
            MongoPartition mongoPartition = new MongoPartition(n, PartitionerHelper$.MODULE$.createBoundaryQuery(shardKey, bsonDocument.getDocument((Object)"min").get((Object)shardKey), bsonDocument.getDocument((Object)"max").get((Object)shardKey)), (Seq<String>)((Seq)shardsMap.getOrElse((Object)bsonDocument.getString((Object)"shard").getValue(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)));
            return mongoPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MongoPartition.class));
    }

    public MongoPartition[] generateCompoundKeyPartitions(Seq<BsonDocument> chunks, BsonDocument shardKey, scala.collection.immutable.Map<String, Seq<String>> shardsMap) {
        List shardKeys = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(shardKey.keySet()).asScala()).toList();
        return (MongoPartition[])((TraversableOnce)((TraversableLike)chunks.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int i;
            BsonDocument chunk;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    chunk = (BsonDocument)tuple2._1();
                    i = tuple2._2$mcI$sp();
                    if (chunk != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            BsonDocument bsonDocument = chunk;
            int n = i;
            BsonDocument min = bsonDocument.getDocument((Object)"min");
            BsonDocument max = bsonDocument.getDocument((Object)"max");
            BsonDocument queryBounds = new BsonDocument();
            shardKeys.map((Function1 & Serializable & scala.Serializable)k -> {
                BsonDocument shardKeyBoundary = PartitionerHelper$.MODULE$.createBoundaryQuery((String)k, min.get(k, (BsonValue)new BsonMinKey()), max.get(k, (BsonValue)new BsonMaxKey()));
                return shardKeyBoundary.containsKey(k) ? queryBounds.put(k, shardKeyBoundary.get(k)) : BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom());
            MongoPartition mongoPartition = new MongoPartition(n, queryBounds, (Seq<String>)((Seq)shardsMap.getOrElse((Object)bsonDocument.getString((Object)"shard").getValue(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)));
            return mongoPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(MongoPartition.class));
    }

    public scala.collection.immutable.Map<String, Seq<String>> mapShards(MongoConnector connector) {
        return (scala.collection.immutable.Map)connector.withCollectionDo((MongoCollectionConfig)new ReadConfig("config", "shards", ReadConfig$.MODULE$.apply$default$3(), ReadConfig$.MODULE$.apply$default$4(), ReadConfig$.MODULE$.apply$default$5(), ReadConfig$.MODULE$.apply$default$6(), ReadConfig$.MODULE$.apply$default$7(), ReadConfig$.MODULE$.apply$default$8(), ReadConfig$.MODULE$.apply$default$9(), ReadConfig$.MODULE$.apply$default$10(), ReadConfig$.MODULE$.apply$default$11(), ReadConfig$.MODULE$.apply$default$12(), ReadConfig$.MODULE$.apply$default$13(), ReadConfig$.MODULE$.apply$default$14(), ReadConfig$.MODULE$.apply$default$15(), ReadConfig$.MODULE$.apply$default$16(), ReadConfig$.MODULE$.apply$default$17()), (Function1 & Serializable & scala.Serializable)collection -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)collection.find().projection(Projections.include((String[])new String[]{"_id", "host"})).into(new ArrayList())).asScala()).map((Function1 & Serializable & scala.Serializable)shard -> new Tuple2((Object)shard.getString((Object)"_id").getValue(), this.getHosts(shard.getString((Object)"host").getValue())), Buffer$.MODULE$.canBuildFrom())), ClassTag$.MODULE$.apply(BsonDocument.class));
    }

    public Seq<String> getHosts(String hosts) {
        return (Seq)((SeqLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts.split(","))).toSeq().map((Function1 & Serializable & scala.Serializable)hostAndPort -> this.getHost((String)hostAndPort), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public String getHost(String hostAndPort) {
        return new ServerAddress((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hostAndPort.split("/"))).reverse())).head()).getHost();
    }

    public MongoShardedPartitioner() {
        this.DefaultShardKey = "_id";
        this.ID_FIELD = "_id";
        this.NAMESPACE_FIELD = "ns";
        this.UUID_FIELD = "uuid";
        this.DROPPED_FIELD = "dropped";
    }
}

